<?php

namespace Drupal\theme_change\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of ThemeChange.
 */
class ThemeChangeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Label');
    $header['type'] = $this->t('Type');
    $header['path'] = $this->t('Path');
    $header['route'] = $this->t('Route');
    $header['theme'] = $this->t('Theme');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['type'] = $entity->getType();
    if ($entity->getPath()) {
      $row['path'] = $entity->getPath();
    }
    else {
      $row['path'] = '-';
    }
    if ($entity->getRoute()) {
      $row['route'] = $entity->getRoute();
    }
    else {
      $row['route'] = '-';
    }
    $theme_name = \Drupal::service('theme_handler')
      ->getName($entity->getTheme());
    $row['theme'] = $theme_name;
    return $row + parent::buildRow($entity);
  }

}
