/**
 * @file
 * Adds JS functionality for theme rule module.
 */

(function ($, window, Drupal) {
  Drupal.behaviors.themeRuleConditions = {
    attach: function attach() {
      if (typeof $.fn.drupalSetSummary === 'undefined') {
        return;
      }

      function checkboxesSummary(context) {
        const vals = [];
        const $checkboxes = $(context).find(
          'input[type="checkbox"]:checked + label',
        );
        const il = $checkboxes.length;

        for (let i = 0; i < il; i++) {
          vals.push($($checkboxes[i]).html());
        }

        if (!vals.length) {
          vals.push(Drupal.t('Not restricted'));
        }

        return vals.join(', ');
      }

      $(
        '[data-drupal-selector="edit-conditions-node-type"], [data-drupal-selector="edit-conditions-language"], [data-drupal-selector="edit-conditions-user-role"]',
      ).drupalSetSummary(checkboxesSummary);
      $(
        '[data-drupal-selector="edit-conditions-request-path"]',
      ).drupalSetSummary(function (context) {
        const $pages = $(context).find(
          'textarea[name="conditions[request_path][pages]"]',
        );

        if (!$pages[0].value) {
          return Drupal.t('Not restricted');
        }

        return Drupal.t('Restricted to certain pages');
      });
    },
  };
})(jQuery, window, Drupal);
