<?php

declare(strict_types=1);

namespace Drupal\theme_rule_test\Plugin\Condition;

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\Condition\ConditionPluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\State\StateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a condition to be used in tests.
 *
 * @Condition(
 *   id = "theme_rule_test",
 * )
 */
class ThemeRuleTestCondition extends ConditionPluginBase implements ContainerFactoryPluginInterface {

  /**
   * The state service.
   */
  protected StateInterface $state;

  public function __construct(array $configuration, string $plugin_id, mixed $plugin_definition, StateInterface $state) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->state = $state;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('state')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'rule' => NULL,
    ] + parent::defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function evaluate(): bool {
    $winning_rules = $this->state->get('theme_rule_test.winning_rules');
    return in_array($this->getConfig()['rule'], $winning_rules, TRUE);
  }

  /**
   * {@inheritdoc}
   */
  public function summary(): MarkupInterface {
    return $this->t('Rule @rule', ['@rule' => $this->getConfig()['rule']]);
  }

}
