# Thin Progress Bar

A Drupal module that adds a smart, thin progress bar to your site. Unlike traditional progress bars, this one only appears during slow page loads, reducing visual noise while providing helpful feedback when needed.

## Features

- **Smart timing** - Only shows when page load exceeds configurable threshold
- **Ultra-thin design** - Choose between 1px or 2px thickness
- **Customizable appearance** - Adjust colors and animation speeds
- **AJAX support** - Works with Drupal's AJAX system
- **Lightweight** - Minimal performance impact
- **Mobile-friendly** - Responsive design that works on all devices

## Requirements

- Drupal 11.x
- No additional modules or libraries required

## Installation

1. Copy the module to your `modules/custom/` directory
2. Enable the module:
   - Via Drush: `drush en thin_progress_bar`
   - Or via admin interface: `/admin/modules`

## Configuration

Visit `/admin/appearance/settings` and scroll to "Thin Progress Bar Settings":

### Basic Options
- **Enable Progress Bar** - Toggle the module on/off
- **Enable on page load** - Show during regular page loads
- **Slow Load Threshold** - Set how long to wait before showing (100-5000ms)
- **Enable on AJAX** - Show during AJAX operations

### Appearance Options
- **Animation Speed** - Fast (1.2s), Normal (2.5s), or Slow (4s)
- **Thickness** - Thin (2px) or Ultra Thin (1px)
- **Progress Bar Color** - Use color picker to match your theme

## How It Works

The module monitors page load time and only displays the progress bar if loading takes longer than your configured threshold. This prevents unnecessary visual noise during fast page loads while still providing feedback during slow loads.

## Use Cases

- Content-heavy sites with varying load times
- E-commerce sites with complex product pages
- Sites with third-party integrations that may slow loading
- Mobile sites where network conditions vary
- Any site wanting to provide loading feedback without visual clutter

## Technical Details

- Uses Drupal's Once API for modern JavaScript practices
- Compatible with Drupal's admin toolbar
- Console logging available for debugging
- No jQuery dependencies

## Support

Please use the Drupal.org issue queue for bug reports and feature requests.

## License

GPL-2.0-or-later

## Author afagioli | augustofagioli@gmail.com
