/**
 * @file
*/
(function (Drupal, once) {
  'use strict';

  Drupal.behaviors.ThronPlayerEmbedd = {
    attach: function (context, settings) {
      if (!(settings.thron && settings.thron.players)) return;

      for (const k in settings.thron.players) {
        if (!Object.prototype.hasOwnProperty.call(settings.thron.players, k)) continue;

        const options = settings.thron.players[k];
        const playerId = 'THRONPlayer_instance__' + k;

        // Esegue una sola volta per #id-k nel context
        once('ThronPlayerEmbedd', '#id-' + k, context).forEach(function (el) {
          // Se vuoi essere iper-sicuro, evita doppie init globali:
          if (!window[playerId]) {
            window[playerId] = THRONContentExperience('id-' + k, options);
          }
        });
      }
    }
  };

})(Drupal, once);