# Feature overview

## Highlights

**Gin Admin Theme**: A radically new UI layout paired with goodies like a Darkmode will give your Drupal's Admin
interface a facelift. The Gin theme also includes things which are currently out of scope for Claro and/or some
customisations we're experimenting with for the future. Built on the foundation of Claro from one of the lead
designers of Claro & Drupal Design System.\
[https://www.drupal.org/project/gin](https://www.drupal.org/project/gin)

**Content Moderation**: Content Moderation enables you to have an editorial workflow. Editors can have different
permissions for creating, editing and publishing articles. It also allows you to have a published version of an article,
and have a separate working copy that is undergoing review before it is published.

**Paragraphs**: Instead of putting all their content in one WYSIWYG body field including images and videos, end-users
can now choose on-the-fly between pre-defined Paragraph Types independent from one another. Paragraph Types can be
anything you want from a simple text block or image to a complex and configurable slideshow. This allows editors to
structure an article into sub-elements, which can easily be created, edited, and reorganized.\
[https://www.drupal.org/project/paragraphs](https://www.drupal.org/project/paragraphs)

**Media Library**: The media library gives you an overview of all your media entities, such as pictures and videos.
You can filter and search for them, edit them, and add new media.

**Autosave Form**: The “Autosave Form” module provides an autosave feature for all forms. The autosave submits will be
triggered every 60 seconds and store the changes from the currently logged-in user in the database.\
[https://www.drupal.org/project/autosave_form](https://www.drupal.org/project/autosave_form)

**Update helper**: The module offers supporting functionalities to make configuration updates easier. It's a combination
of the modules Checklist API and Configuration Update Manager. The Update helper checks if installed configurations have
been changed – if not, they can be updated. Otherwise you will get a message telling you that there’s an available
update and what to do if you wish to have it.\
[https://www.drupal.org/project/checklist](https://www.drupal.org/project/checklist) \
[https://www.drupal.org/project/update_helper](https://www.drupal.org/project/update_helper)

## Installed by default

**Access Unpublished**: Easy to use module grants access to view unpublished content to anyone who has a unique URL and
appropriate permissions. Visitor can be anonymous or authenticated user with the user role.\
[https://www.drupal.org/project/access_unpublished](https://www.drupal.org/project/access_unpublished)

**Admin Toolbar**: Admin Toolbar transforms the default Drupal Toolbar into a drop-down menu, providing a fast access to
all administration pages.\
[https://www.drupal.org/project/admin_toolbar](https://www.drupal.org/project/admin_toolbar)

**Autofill**: The Autofill module makes it possible to autofill the values from one textfield to another while typing.
Once your field input was customized the autofill functionality will be detached.\
[https://www.drupal.org/project/autofill](https://www.drupal.org/project/autofill)

**Content Lock**: When a user is editing a node, any other user that attempts to edit the same node will be blocked from
doing so, and notified that the content is already being edited.\
[https://www.drupal.org/project/content_lock](https://www.drupal.org/project/content_lock)

**Diff**: This module adds a tab that shows all revisions like standard Drupal but it also allows pretty viewing of all
added/changed/deleted words between revisions.\
[https://www.drupal.org/project/diff](https://www.drupal.org/project/diff)

**Dropzonejs**: Open source library that provides drag’n’drop file uploads with image previews.\
[https://www.drupal.org/project/dropzonejs](https://www.drupal.org/project/dropzonejs)

**Empty Fields**: This module provides a way to show empty fields that would otherwise be hidden.\
[https://www.drupal.org/project/empty_fields](https://www.drupal.org/project/empty_fields)

**Field Group**: Fieldgroup will group fields together. All fieldable entities will have the possibility to add groups
to wrap their fields together.\
[https://www.drupal.org/project/field_group](https://www.drupal.org/project/field_group)

**Focal Point (using Crop API)**: Focal Point allows you to specify the portion of an image that is most important. This
information can be used when the image is cropped or cropped and scaled so that you don't, for example, end up with an
image that cuts off the subject's head.\
[https://www.drupal.org/project/focal_point](https://www.drupal.org/project/focal_point)

**Inline Entity Form**: Provides a widget for inline management (creation, modification, removal) of referenced
entities. For example, pictures, videos, or social media cards can be edited in the article form.\
[https://www.drupal.org/project/inline_entity_form](https://www.drupal.org/project/inline_entity_form)

**Length Indicator**: With the help of the module Length Indicator, you can add a colored length indicator to form
fields. You can choose an area of optimal length and a tolerance, which will be added and subtracted to/from the optimal
boundaries. In Thunder, we implemented the Length Indicator for the SEO text field.\
[https://www.drupal.org/project/length_indicator](https://www.drupal.org/project/length_indicator)

**Linkit – Enriched linking experience**: Linkit provides an easy interface for internal and external linking with
wysiwyg editors by using an autocomplete field. Linkit has by default support for nodes, users, taxonomy terms, files,
comments and basic support for all types of entities that defines a canonical link template.\
[https://www.drupal.org/project/linkit](https://www.drupal.org/project/linkit)

**Metatag**: The Metatag module allows you to automatically provide structured metadata, aka "meta tags", about a
website. In the context of search engine optimization, the meta description tag and the meta keywords tag may help
improve the rankings and display of a site in search engine results. In addition, the module provides support for meta
tags (Open Graph Protocol from Facebook, Twitter Cards from Twitter) that allow control of how content appears when
shared on social networks.\
[https://www.drupal.org/project/metatag](https://www.drupal.org/project/metatag)

**Media entity slideshow**: Slideshows integration for Media entity module. In Thunder, this is used to create
galleries.\
[https://www.drupal.org/project/media_entity_slideshow](https://www.drupal.org/project/media_entity_slideshow)

**Media entity Instagram**: Instagram integration for Media entity module.\
[https://www.drupal.org/project/media_entity_instagram](https://www.drupal.org/project/media_entity_instagram)

**Media Entity Pinterest**: Pinterest integration for Media entity module.\
[https://www.drupal.org/project/media_entity_pinterest](https://www.drupal.org/project/media_entity_pinterest)

**Media entity twitter**: Twitter integration for Media entity module.\
[https://www.drupal.org/project/media_entity_twitter](https://www.drupal.org/project/media_entity_twitter)

**Media expire**: This module enables you to unpublish your media entities automatically by setting an expire date.\
[https://www.drupal.org/project/media_expire](https://www.drupal.org/project/media_expire)

**Paragraphs Features**: This module adds additional features to the paragraphs module.

1. Provides additional buttons between paragraphs to allow easier adding of a new paragraph to as specific position.
2. When there is only one option in the actions drop-down, this will be display that as a single button instead of a
   drop down with only one value.
3. Provide a delete confirmation form.

[https://www.drupal.org/project/paragraphs_features](https://www.drupal.org/project/paragraphs_features)

**Pathauto**: The Pathauto module automatically generates URL/path aliases for various kinds of content (nodes, taxonomy
terms, users) without requiring the user to manually specify the path alias. The aliases are based upon a "pattern"
system that uses tokens which the administrator can change.\
[https://www.drupal.org/project/pathauto](https://www.drupal.org/project/pathauto)

**Redirect**: The Redirect module automatically adds redirects if the URL of an article has been changed.\
[https://www.drupal.org/project/redirect](https://www.drupal.org/project/redirect)

**Scheduler**: Scheduler gives content editors the ability to schedule nodes to be published and unpublished at
specified dates and times in the future. Dates can be entered either as plain text or with calendar popups.\
[https://www.drupal.org/project/scheduler](https://www.drupal.org/project/scheduler)

**Tagify**: Integrates Drupal autocomplete and select fields with the [Tagify](https://yaireo.github.io/tagify/) jQuery library.
Provides advanced autocomplete functionality for select fields and entity reference fields.\
[https://www.drupal.org/project/tagify](https://www.drupal.org/project/tagify)

**Simple XML sitemap**: Every webpage needs an automatic XML sitemap generator for SEO reasons. This module aims to be a
replacement for the XML sitemap module for Drupal. Simple xml sitemap is lighter than XML sitemap in terms of resources
and usability. Sitemaps generated by this module adhere to the new Google standard regarding multilingual content by
creating hreflang sitemaps and image sitemaps.\
[https://www.drupal.org/project/simple_sitemap](https://www.drupal.org/project/simple_sitemap)

**Token**: Provides additional tokens not supported by core (most notably fields), as well as a UI for browsing
tokens.\
[https://www.drupal.org/project/token](https://www.drupal.org/project/token)

## Optional installable

**Search API** This module provides a framework for easily creating searches on any entity known to Drupal, using any
kind of search engine.\
[https://www.drupal.org/project/search_api](https://www.drupal.org/project/search_api)

**IVW Integration**: This is an integration module for the German audience measurement organisation IVW.\
[https://www.drupal.org/project/ivw_integration](https://www.drupal.org/project/ivw_integration)

**Password Policy**: Provides a way to enforce restrictions on user passwords by defining password policies.\
[https://www.drupal.org/project/password_policy](https://www.drupal.org/project/password_policy)
