<?php

declare(strict_types=1);

namespace Drupal\time_based_condition;

/**
 * Defines an interface for classes that process the timeframe.
 */
interface TimeframeServiceInterface {

  /**
   * Checks if the set timeframe applies
   */
  public function applies(int|null $from_timestamp, int|null $to_timestamp): bool;

  /**
   * Computes the cache max age based on the given timestamps
   */
  public function computeCacheMaxAge(int $timestamp_from, int $timestamp_to): int;

}
