/* jshint -W065 */
/**
 * @file
 * Renders progress bar for title accessibility.
 */

((Drupal, drupalSettings) => {
  const totalValue = 255;
  const minSegmentWidth = 10;
  const segments = Array.from(document.querySelectorAll('.segment'));

  // Initial proportions (sum = 1)
  const proportions = [0.2, 0.2, 0.2, 0.2, 0.2];

  function updateValueProportions() {
    segments.forEach((seg, i) => {
      let dynamicPortion = '';
      if (document.getElementById(`edit-val${i}`)) {
        dynamicPortion =
          document.getElementById(`edit-val${i}`).value / totalValue;
      } else {
        dynamicPortion = drupalSettings.title_a11y[`val${i}`] / totalValue;
      }

      proportions[i] = dynamicPortion;
    });
  }
  function getTotalWidth() {
    return document.getElementById('progress-bar').clientWidth;
  }

  function updateUI() {
    const totalWidth = getTotalWidth();
    segments.forEach((seg, i) => {
      const width = Math.round(proportions[i] * totalWidth);
      const value = Math.round(proportions[i] * totalValue);
      seg.style.width = `${width}px`;
      seg.setAttribute('title', `${value}chars`);
      if (document.getElementById(`edit-val${i}`)) {
        document.getElementById(`edit-val${i}`).value = value;
      }
    });
  }

  let dragging = false;
  let currentHandle = null;

  if (document.getElementById('edit-val0')) {
    const handles = Array.from(document.querySelectorAll('.handle'));
    handles.forEach((handle) => {
      handle.addEventListener('mousedown', () => {
        dragging = true;
        currentHandle = Number(handle.dataset.index);
      });
    });
  }

  document.addEventListener('mouseup', () => {
    dragging = false;
    currentHandle = null;
  });

  document.addEventListener('mousemove', (e) => {
    if (!dragging) return;

    const bar = document.getElementById('progress-bar');
    const rect = bar.getBoundingClientRect();
    const totalWidth = getTotalWidth();
    const x = e.clientX - rect.left;

    const pixelWidths = proportions.map((p) => p * totalWidth);
    const leftSum = pixelWidths
      .slice(0, currentHandle)
      .reduce((a, b) => a + b, 0);
    const rightSum = pixelWidths
      .slice(currentHandle + 2)
      .reduce((a, b) => a + b, 0);
    const maxLeft = totalWidth - rightSum - minSegmentWidth;
    const minLeft = leftSum + minSegmentWidth;

    const newLeft = Math.max(minLeft, Math.min(x, maxLeft));
    const newWidthLeft = newLeft - leftSum;
    const newWidthRight =
      pixelWidths[currentHandle] +
      pixelWidths[currentHandle + 1] -
      newWidthLeft;

    if (newWidthLeft >= minSegmentWidth && newWidthRight >= minSegmentWidth) {
      proportions[currentHandle] = newWidthLeft / totalWidth;
      proportions[currentHandle + 1] = newWidthRight / totalWidth;
      updateUI();
    }
  });

  // Redraw when resize
  window.addEventListener('resize', updateUI);

  updateValueProportions();
  updateUI();

  function updateCursorMarker() {
    const textField = document.getElementById('edit-title-0-value');
    const cursorMarker = document.getElementById('cursor-marker');
    const progressBar = document.getElementById('progress-bar');
    const totalWidth = progressBar.clientWidth;
    const maxChars = 255;
    const charIndex = Math.max(0, textField.selectionStart); // cursor position
    const left = (charIndex / maxChars) * totalWidth;
    cursorMarker.style.left = `${left}px`;
  }

  if (document.getElementById('edit-title-0-value')) {
    const textField = document.getElementById('edit-title-0-value');
    textField.addEventListener('input', updateCursorMarker);
    window.addEventListener('resize', updateCursorMarker);
  }
})(Drupal, drupalSettings);
