<?php

namespace Drupal\title_a11y\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure accessibility progress bar for titles.
 *
 * @internal
 */
class AdminTitleA11y extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['title_a11y.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'title_a11y_admin_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('title_a11y.settings');

    $form['#attached']['library'][] = 'title_a11y/title_a11y';

    $form['intro_text'] = [
      '#markup' => '<p><strong>' . $this->t('Select the character ranges that will be shown to the editor while they are typing the content title.') . '</strong></p>' .
      '<p>' . $this->t('These ranges will serve as a guide to indicate the level of accessibility compliance for titles, helping ensure they are clear, concise, and suitable for all audiences.') . '</p>',
    ];

    $form['progress_bar'] = [
      '#markup' => '
  <div class="container-progress-bar">
    <div id="progress-bar">
      <div class="segment red" data-index="0"></div>
      <div class="handle" data-index="0"></div>
      <div class="segment yellow" data-index="1"></div>
      <div class="handle" data-index="1"></div>
      <div class="segment green" data-index="2"></div>
      <div class="handle" data-index="2"></div>
      <div class="segment yellow" data-index="3"></div>
      <div class="handle" data-index="3"></div>
      <div class="segment red" data-index="4"></div>
    </div>
  </div>
  ',
    ];

    $form['val0'] = [
      '#type' => 'number',
      '#title' => $this->t('Red (Zone 1)'),
      '#default_value' => $config->get('val0'),
      '#attributes' => [
        'readonly' => 'readonly',
      ],
      '#description' => $this->t('Characters for this zone.'),
    ];
    $form['val1'] = [
      '#type' => 'number',
      '#title' => $this->t('Yellow (Zone 1)'),
      '#default_value' => $config->get('val1'),
      '#attributes' => [
        'readonly' => 'readonly',
      ],
      '#description' => $this->t('Characters for this zone.'),
    ];
    $form['val2'] = [
      '#type' => 'number',
      '#title' => $this->t('Green'),
      '#default_value' => $config->get('val2'),
      '#attributes' => [
        'readonly' => 'readonly',
      ],
      '#description' => $this->t('Characters for this zone.'),
    ];
    $form['val3'] = [
      '#type' => 'number',
      '#title' => $this->t('Yellow (Zone 2)'),
      '#default_value' => $config->get('val3'),
      '#attributes' => [
        'readonly' => 'readonly',
      ],
      '#description' => $this->t('Characters for this zone.'),
    ];
    $form['val4'] = [
      '#type' => 'number',
      '#title' => $this->t('Red (Zone 2)'),
      '#default_value' => $config->get('val4'),
      '#attributes' => [
        'readonly' => 'readonly',
      ],
      '#description' => $this->t('Characters for this zone.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('title_a11y.settings')
      ->set('val0', $form_state->getValue('val0'))
      ->set('val1', $form_state->getValue('val1'))
      ->set('val2', $form_state->getValue('val2'))
      ->set('val3', $form_state->getValue('val3'))
      ->set('val4', $form_state->getValue('val4'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
