<?php

namespace Drupal\tlsrpt\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Render\Element;

/**
 * Implements hook_theme().
 */
#[Hook('theme')]
class Theme {

  /**
   * Implements hook_theme().
   *
   * @return array<string, array<string, string>>
   *   An associative array of theme hook information.
   */
  public function __invoke(): array {
    return [
      'tlsrpt' => [
        'render element' => 'elements',
        'initial preprocess' => static::class . ':preprocessTlsrpt',
      ],
    ];
  }

  /**
   * Prepares variables for TLSRPT templates.
   *
   * Default template: tlsrpt.html.twig.
   *
   * @param array{elements: mixed[], attributes: mixed[]} $variables
   *   An associative array containing:
   *   - elements: An associative array containing the TLSRPT information
   *     and any fields attached to the entity.
   *   - attributes: HTML attributes for the containing element.
   */
  public function preprocessTlsrpt(array &$variables): void {
    $variables['view_mode'] = $variables['elements']['#view_mode'];
    foreach (Element::children($variables['elements']) as $key) {
      $variables['content'][$key] = $variables['elements'][$key];
    }
  }

}
