<?php

namespace Drupal\tmgmt_asymmetric_block\Events;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\layout_builder\Section;
use Drupal\tmgmt\JobInterface;

/**
 * Event for the tmgmt finished event.
 */
class TmgmtFinishedEvent extends Event {

  const string UPDATE_SECTIONS = 'tmgmt_asymmetric_block.update_sections';
  const string UPDATE_SECTION_COMPONENTS = 'tmgmt_asymmetric_block.update_section_components';
  const string TRANSLATE_FIELDS = 'tmgmt_asymmetric_block.translate_fields';

  /**
   * The job.
   *
   * @var \Drupal\tmgmt\JobInterface
   */
  protected JobInterface $job;

  /**
   * The translated entity.
   *
   * @var \Drupal\Core\Entity\ContentEntityInterface
   */
  protected ContentEntityInterface $translatedEntity;

  /**
   * The sections.
   *
   * @var array<int, \Drupal\layout_builder\Section>
   */
  protected array $sections;

  /**
   * The components.
   *
   * @var array<string, \Drupal\layout_builder\SectionComponent>
   */
  protected array $components;
  /**
   * The job items.
   *
   * @var array<int, \Drupal\tmgmt\JobItemInterface>
   */
  protected array $jobItems;

  /**
   * The section.
   *
   * @var \Drupal\layout_builder\Section
   */
  protected Section $section;

  /**
   * The source entity.
   *
   * @var \Drupal\Core\Entity\ContentEntityInterface
   */
  protected ContentEntityInterface $sourceEntity;

  /**
   * Constructor.
   *
   * @param \Drupal\tmgmt\JobInterface $job
   *   The job.
   */
  public function __construct(JobInterface $job) {
    $this->job = $job;
  }

  /**
   * The mapped uuids.
   *
   * @var array<string, string>
   */
  protected array $mappedUuids = [];

  /**
   * Set the sections.
   *
   * @param array<int, \Drupal\layout_builder\Section> $sections
   *   The sections.
   */
  public function setSections(array $sections): void {
    $this->sections = $sections;
  }

  /**
   * Get the sections.
   *
   * @return array<int, \Drupal\layout_builder\Section>
   *   The sections.
   */
  public function getSections(): array {
    return $this->sections;
  }

  /**
   * Set the section.
   *
   * @param \Drupal\layout_builder\Section $section
   *   The section.
   */
  public function setSection(Section $section): void {
    $this->section = $section;
  }

  /**
   * Get the section.
   *
   * @return \Drupal\layout_builder\Section
   *   The section.
   */
  public function getSection(): Section {
    return $this->section;
  }

  /**
   * Set the components.
   *
   * @param array<int, \Drupal\layout_builder\SectionComponent> $components
   *   The components.
   */
  public function setComponents(array $components): void {
    $this->components = $components;
  }

  /**
   * Get the components.
   *
   * @return array<int, \Drupal\layout_builder\SectionComponent>
   *   The components.
   */
  public function getComponents(): array {
    return $this->components;
  }

  /**
   * Get the job items.
   *
   * @return array<int, \Drupal\tmgmt\JobItemInterface>
   *   The job items.
   */
  public function getJobItems(): array {
    return $this->jobItems;
  }

  /**
   * Set the job items.
   *
   * @param array<int, \Drupal\tmgmt\JobItemInterface> $jobItems
   *   The job items.
   */
  public function setJobItems(array $jobItems): void {
    $this->jobItems = $jobItems;
  }

  /**
   * Get the job items.
   *
   * @return array<int, \Drupal\tmgmt\JobItemInterface>
   *   The job items.
   */
  public function setSourceEntity(ContentEntityInterface $sourceEntity): void {
    $this->sourceEntity = $sourceEntity;
  }

  /**
   * Get the source entity.
   */
  public function getSourceEntity(): ContentEntityInterface {
    return $this->sourceEntity;
  }

  /**
   * Set the block components.
   *
   * @param \Drupal\layout_builder\Section $section
   *   The section.
   * @param array<int, \Drupal\layout_builder\SectionComponent> $components
   *   The components.
   * @param array<int, \Drupal\tmgmt\JobItemInterface> &$job_items
   *   The job items.
   */
  public function setBlockComponents(Section $section, array $components, array &$job_items): void {
    $this->section = $section;
    $this->components = $components;
    $this->jobItems = $job_items;
  }

  /**
   * Set the mapped uuids.
   *
   * @param array<string, string> $mapped_uuids
   *   The mapped uuids.
   */
  public function setMappedUuids(array $mapped_uuids): void {
    $this->mappedUuids = array_unique(array_merge($this->mappedUuids, $mapped_uuids));
  }

  /**
   * Get the mapped uuids.
   *
   * @return array<string, string>
   *   The mapped uuids.
   */
  public function getMappedUuids(): array {
    return $this->mappedUuids;
  }

  /**
   * Set the translated entity.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $translatedEntity
   *   The translated entity.
   */
  public function setTranslatedEntity(ContentEntityInterface $translatedEntity): void {
    $this->translatedEntity = $translatedEntity;
  }

  /**
   * Get the translated entity.
   *
   * @return \Drupal\Core\Entity\ContentEntityInterface
   *   The translated entity.
   */
  public function getTranslatedEntity(): ContentEntityInterface {
    return $this->translatedEntity;
  }

}
