<?php

namespace Drupal\tmgmt_asymmetric_block\Plugin\tmgmt\Source;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\tmgmt\JobItemInterface;
use Drupal\tmgmt_content\Plugin\tmgmt\Source\ContentEntitySource;

/**
 * Content entity source plugin controller for handling asymmetric translation.
 */
class TmgmtAsymmetricBlockContentEntitySource extends ContentEntitySource {

  /**
   * Saves translation data in an entity translation.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity for which the translation should be saved.
   * @param array $data
   *   The translation data for the fields.
   * @param string $target_langcode
   *   The target language.
   * @param \Drupal\tmgmt\JobItemInterface $item
   *   The job item.
   * @param bool $save
   *   (optional) Whether to save the translation or not.
   *
   * @throws \Exception
   *   Thrown when a field or field offset is missing.
   */
  protected function doSaveTranslations(ContentEntityInterface $entity, array $data, $target_langcode, JobItemInterface $item, $save = TRUE): void {
    // Do nothing, accept the translation and at the end save everything at
    // once.
  }

}
