# Translation Management Auto Translate

This module extends the Translation Management Tool (TMGMT) module to provide automatic translation of content when it is published or when a specific moderation state transition occurs.

## Features

- Automatically translate content when it is published
- For content types using content moderation, translate content when a specific moderation transition occurs
- Configure which content types should be automatically translated
- Configure per-content type settings:
  - Select which translation provider to use for each content type
  - Choose which target languages to translate each content type to
  - Set specific moderation transitions for each content type

## Requirements

- Drupal 9, 10 or 11
- Translation Management Tool (TMGMT) module
- Node module
- (Optional) Content Moderation module for moderation state transition support

## Installation

1. Install the module as you would normally install a Drupal module.
2. Go to `/admin/config/regional/tmgmt/settings` to configure the module.

## Configuration

1. Go to `/admin/config/regional/tmgmt/settings`
2. In the "Automatic translation settings" section:
   - Select which content types should be automatically translated
   - For each selected content type, click on its settings section to configure:
     - The translation provider to use for this content type
     - The target languages to translate this content type to (if none selected, all available languages will be used)
     - For content types using content moderation, the moderation transition that should trigger automatic translation

## How it works

When a node of a selected content type is published (or undergoes the selected moderation transition), the module will:

1. Check if the node's content type is configured for automatic translation
2. For moderated content types, check if the transition matches the configured one for that content type
3. Use the translation provider configured for that specific content type
4. Create a translation job for each target language selected for that content type (or all available languages if none selected, except the source language)
5. Request translation using the content type's configured translation provider

## Troubleshooting

Check the Drupal logs for any errors related to the automatic translation process. Common issues include:

- No translation provider configured for a specific content type
- Translation provider not available or misconfigured
- Target languages not properly configured for a content type
- Moderation transition not set correctly for a content type
- Insufficient permissions for the user account performing the action

## Credits

Developed for the Translation Management Tool (TMGMT) module to provide automatic translation functionality.
