<?php

namespace Drupal\tmgmt_deepl_glossary\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the glossary item widget.
 *
 * @FieldWidget(
 *   id = "deepl_glossary_item_widget",
 *   label = @Translation("Glossary item"),
 *   field_types = {
 *     "deepl_glossary_item"
 *   }
 * )
 */
class DeeplGlossaryItemWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state): array {
    $item = $items[$delta];

    // Subject.
    $element['subject'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Subject'),
      '#description' => $this->t('Enter the subject of the glossary item.'),
      '#default_value' => $item->subject ?? NULL,
      '#maxlength' => 255,
    ];

    // Definition.
    $element['definition'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Definition'),
      '#description' => $this->t('Enter the definition of the glossary item.'),
      '#default_value' => $item->definition ?? NULL,
      '#maxlength' => 255,
    ];

    return $element;
  }

}
