<?php

namespace Drupal\Tests\tmgmt_deepl\Unit\Plugin\QueueWorker;

use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\tmgmt_deepl\DeeplTranslatorBatch;
use Drupal\tmgmt_deepl\Plugin\QueueWorker\DeeplTranslateWorker;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\MockObject\MockObject;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Tests the DeeplTranslateWorkerTest.
 */
#[CoversClass(DeeplTranslateWorker::class)]
#[Group('tmgmt_deepl')]
class DeeplTranslateWorkerTest extends UnitTestCase {

  /**
   * The mocked container.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected ContainerInterface|MockObject $container;

  /**
   * The mocked logger factory.
   *
   * @var \Drupal\Core\Logger\LoggerChannelFactoryInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected LoggerChannelFactoryInterface|MockObject $loggerFactory;

  /**
   * The mocked logger channel.
   *
   * @var \Drupal\Core\Logger\LoggerChannelInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected LoggerChannelInterface|MockObject $loggerChannel;

  /**
   * The mocked batch wrapper.
   *
   * @var \Drupal\tmgmt_deepl\DeeplTranslatorBatch|\PHPUnit\Framework\MockObject\MockObject
   */
  protected DeeplTranslatorBatch|MockObject $batch;

  /**
   * The DeeplTranslateWorker instance to test.
   *
   * @var \Drupal\tmgmt_deepl\Plugin\QueueWorker\DeeplTranslateWorker
   */
  protected DeeplTranslateWorker $worker;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->loggerChannel = $this->createMock(LoggerChannelInterface::class);
    $this->batch = $this->createMock(DeeplTranslatorBatch::class);

    $string_translation = $this->createMock(TranslationInterface::class);
    $string_translation->expects($this->any())
      ->method('translate')
      ->willReturnArgument(0);

    $this->worker = new DeeplTranslateWorker(
      [],
      'deepl_translate_worker',
      ['provider' => 'tmgmt_deepl'],
      $this->loggerChannel,
      $this->batch
    );
    $this->worker->setStringTranslation($string_translation);
  }

  /**
   * Tests the method ::processItem.
   */
  public function testProcessItem(): void {
    // Mock the necessary objects and data.
    $job = $this->createMock('Drupal\tmgmt\Entity\Job');
    $job_item = $this->createMock('Drupal\tmgmt\Entity\JobItem');
    $job_item->expects($this->any())
      ->method('id')
      ->willReturn(1);

    $data = [
      'job' => $job,
      'job_item' => $job_item,
      'q' => ['Test text'],
      'translation' => 'Translated text',
      'keys_sequence' => ['key1', 'key2'],
    ];

    $this->batch->expects($this->once())
      ->method('translateOperation')
      ->with($job, ['Test text'], ['key1', 'key2'], $this->anything());

    $this->batch->expects($this->once())
      ->method('finishedOperation')
      ->with(TRUE, $this->arrayHasKey('job_item'), []);

    // Test successful processing.
    $this->worker->processItem($data);
  }

}
