<?php

namespace Drupal\tmgmt_deepl_glossary;

use DeepL\GlossaryInfo;
use Drupal\tmgmt\TranslatorInterface;

/**
 * Provides an interface defining DeepL glossary API batch service.
 */
interface DeeplGlossaryBatchInterface {

  /**
   * Build glossary sync batch for available deepl translators.
   */
  public function buildBatch(): void;

  /**
   * Sync glossary entries batch finish callback.
   *
   * @param bool $success
   *   Whether the batch run was successful.
   * @param array $results
   *   The collected results coming from batch context.
   * @param array $operations
   *   The processed operations.
   */
  public function finishedOperation(bool $success, array $results, array $operations): void;

  /**
   * Sync a single glossary.
   *
   * @param \Drupal\tmgmt\TranslatorInterface $translator
   *   The translator.
   * @param \DeepL\GlossaryInfo $glossary
   *   The glossary info object.
   * @param array<string, string> $entries
   *   The entries of the glossary.
   * @param array<string, mixed> $context
   *   Context for operation.
   */
  public function syncOperation(TranslatorInterface $translator, GlossaryInfo $glossary, array $entries, array &$context): void;

  /**
   * Clean up obsolete deepl_glossary entities.
   *
   * @param array $deepl_glossaries
   *   Array of DeepL glossaries provided by the API.
   * @param string $translator
   *   The name of the translator.
   * @param array $context
   *   Context for operation.
   */
  public function cleanUpOperation(array $deepl_glossaries, string $translator, array &$context): void;

}
