<?php

namespace Drupal\tmgmt_deepl_glossary\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Url;
use Drupal\tmgmt_deepl_glossary\DeeplGlossaryBatchInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a form for syncing deepl_glossary entries.
 *
 * @ingroup tmgmt_deepl_glossary
 */
class DeeplGlossarySyncForm extends ConfirmFormBase {

  public function __construct(
    protected DeeplGlossaryBatchInterface $glossaryBatch,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    // @phpstan-ignore-next-line
    return new static(
      $container->get('tmgmt_deepl_glossary.batch'),
    );
  }

  /**
   * {@inheritDoc}
   */
  public function getFormId(): string {
    return 'tmgmt_deepl_glossary_sync_form';
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText(): TranslatableMarkup {
    return $this->t('Sync DeepL glossaries');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): TranslatableMarkup {
    return $this->t('This action will sync all DeepL glossaries via the DeepL API.');
  }

  /**
   * {@inheritDoc}
   */
  public function getQuestion(): TranslatableMarkup {
    return $this->t('Do you want to sync the latest DeepL glossaries via the DeepL API?');
  }

  /**
   * {@inheritDoc}
   */
  public function getCancelUrl(): Url {
    return new Url('entity.deepl_glossary.collection');
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    // Build sync batch.
    $this->glossaryBatch->buildBatch();

    // Redirect to glossary overview.
    $form_state->setRedirect('entity.deepl_glossary.collection');
  }

}
