<?php

namespace Drupal\tmgmt_deepl_glossary;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\tmgmt\TranslatorInterface;

/**
 * Provides an interface defining a deepl_glossary entity.
 */
interface DeeplGlossaryInterface extends ContentEntityInterface {

  /**
   * Returns a labeled list of all allowed languages.
   *
   * @return array
   *   A list of all allowed languages.
   */
  public static function getAllowedLanguages(): array;

  /**
   * Gets the glossary id.
   *
   * @return string|null
   *   Glossary id of the deepl_glossary.
   */
  public function getGlossaryId(): ?string;

  /**
   * Gets entries count.
   *
   * @return int|null
   *   Number of glossary entries.
   */
  public function getEntryCount(): ?int;

  /**
   * Get the translator of a glossary.
   *
   * @return \Drupal\tmgmt\TranslatorInterface|null
   *   The translator entity object.
   */
  public function getTranslator(): ?TranslatorInterface;

  /**
   * Gets the target language.
   *
   * @return string
   *   Glossary target language.
   */
  public function getTargetLanguage(): string;

  /**
   * Gets the source language.
   *
   * @return string
   *   Glossary source language.
   */
  public function getSourceLanguage(): string;

  /**
   * Gets the entries of the glossary as associative array.
   *
   * @return array
   *   Glossary entries.
   */
  public function getEntries(): array;

}
