<?php

namespace Drupal\tmgmt_deepl_glossary\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'field_deepl_glossary_item' formatter.
 *
 * @FieldFormatter(
 *   id = "deepl_glossary_item_formatter",
 *   module = "tmgmt_deepl_glossary",
 *   label = @Translation("DeepL glossary item formatter"),
 *   field_types = {
 *     "deepl_glossary_item"
 *   }
 * )
 */
class DeeplGlossaryItemFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];

    foreach ($items as $delta => $item) {
      assert($item instanceof FieldItemInterface);
      // Get from field item.
      $values = $item->getValue();
      assert(is_array($values));

      $elements[$delta] = [
        '#type' => 'html_tag',
        '#tag' => 'p',
        '#value' => $this->t('Subject: @subject - Definition: @definition', [
          '@subject' => $values['subject'] ?? '',
          '@definition' => $values['definition'] ?? '',
        ]),
      ];
    }

    return $elements;
  }

}
