<?php

namespace Drupal\tmgmt_deepl_glossary\Plugin\views\filter;

use Drupal\tmgmt_deepl_glossary\Entity\DeeplGlossary;
use Drupal\views\Plugin\views\filter\ManyToOne;
use Drupal\views\ViewExecutable;

/**
 * Filter based on allowed languages for deepl_glossary.
 *
 * @deprecated in tmgmt_deepl:2.3.0-alpha2 and is removed from tmgmt_deepl:2.3.0-alpha3. The filter plugin is obsolete.
 * @see https://www.drupal.org/project/tmgmt_deepl/issues/3528324
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("tmgmt_deepl_glossary_allowed_languages")
 */
class DeeplGlossaryAllowedLanguages extends ManyToOne {

  /**
   * Gets the values of the options.
   *
   * @return array
   *   Returns options.
   */
  public function getValueOptions(): array {
    if (empty($this->valueOptions)) {
      // Clone the view to avoid affecting the original.
      $cloned_view = $this->view->createDuplicate();
      assert($cloned_view instanceof ViewExecutable);

      $display_id = 'page_1';

      // Remove this filter from the cloned view to prevent recursion.
      assert(is_string($this->options['id']));
      $cloned_view->removeHandler($display_id, 'filter', $this->options['id']);

      // Configure the cloned view to return all results.
      $cloned_view->setItemsPerPage(0);
      $cloned_view->setOffset(0);
      $cloned_view->setCurrentPage(0);

      // Execute the cloned view.
      $cloned_view->preExecute();
      $cloned_view->execute();

      // Extract languages from the cloned results.
      $source_languages = [];
      $target_languages = [];
      foreach ($cloned_view->result as $row) {
        assert($row->_entity instanceof DeeplGlossary);
        $source_languages[] = $row->_entity->get('source_lang')->value;
        $target_languages[] = $row->_entity->get('target_lang')->value;
      }

      // Get language codes based on fields.
      $language_codes = [];
      if ($this->realField == 'source_lang') {
        $language_codes = array_unique($source_languages);
      }
      elseif ($this->realField == 'target_lang') {
        $language_codes = array_unique($target_languages);
      }

      $allowed_languages = DeeplGlossary::getAllowedLanguages();
      $language_names = [];
      foreach ($language_codes as $code) {
        /* @phpstan-ignore-next-line */
        if (isset($allowed_languages[$code])) {
          /* @phpstan-ignore-next-line */
          $language_names[$code] = $allowed_languages[$code];
        }
      }

      // Sort by language name while preserving keys.
      asort($language_names);

      $this->valueOptions = $language_names;
    }

    return $this->valueOptions;
  }

}
