<?php

namespace Drupal\Tests\tmgmt_deepl\Unit\Plugin\QueueWorker;

use Drupal\Tests\UnitTestCase;
use Drupal\tmgmt_deepl\DeeplTranslatorBatch;
use Drupal\tmgmt_deepl\Plugin\QueueWorker\DeeplTranslateWorker;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\MockObject\MockObject;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Tests the DeeplTranslateWorker.
 */
#[CoversClass(DeeplTranslateWorker::class)]
#[Group('tmgmt_deepl')]
class DeeplTranslateWorkerTest extends UnitTestCase {

  /**
   * The mocked container.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected ContainerInterface|MockObject $container;

  /**
   * The mocked batch wrapper.
   *
   * @var \Drupal\tmgmt_deepl\DeeplTranslatorBatch|\PHPUnit\Framework\MockObject\MockObject
   */
  protected DeeplTranslatorBatch|MockObject $batch;

  /**
   * The DeeplTranslateWorker instance to test.
   *
   * @var \Drupal\tmgmt_deepl\Plugin\QueueWorker\DeeplTranslateWorker
   */
  protected DeeplTranslateWorker $worker;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->batch = $this->createMock(DeeplTranslatorBatch::class);

    $this->worker = new DeeplTranslateWorker(
      [],
      'deepl_translate_worker',
      ['provider' => 'tmgmt_deepl'],
      $this->batch
    );
  }

  /**
   * Tests the method ::processItem.
   */
  public function testProcessItem(): void {
    // Mock the necessary objects and data.
    $job = $this->createMock('Drupal\tmgmt\Entity\Job');
    $job_item = $this->createMock('Drupal\tmgmt\Entity\JobItem');
    $job_item
      ->method('id')
      ->willReturn(1);

    $data = [
      'job' => $job,
      'job_item' => $job_item,
      'q' => ['Test text'],
      'translation' => 'Translated text',
      'keys_sequence' => ['key1', 'key2'],
    ];

    $this->batch->expects($this->once())
      ->method('translateOperation')
      ->with($job, ['Test text'], ['key1', 'key2'], $this->anything());

    $this->batch->expects($this->once())
      ->method('finishedOperation')
      ->with(TRUE, $this->arrayHasKey('job_item'), []);

    // Test successful processing.
    $this->worker->processItem($data);
  }

}
