<?php

namespace Drupal\tmgmt_google_v3\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event fired immediately after translation is received from Google.
 */
class PostTranslationEvent extends Event {

  const POST_TRANSLATION = 'post_translation';

  /**
   * Creates a new instance of the post translation event.
   */
  public function __construct(private readonly string $key, private string $translatedText) {}

  /**
   * Get the translated text.
   */
  public function getTranslatedText(): string {
    return $this->translatedText;
  }

  /**
   * Modify the translated text.
   */
  public function setTranslatedText(string $translatedText): void {
    $this->translatedText = $translatedText;
  }

  /**
   * Get the translation key (i.e. the field name).
   */
  public function getTranslationKey(): string {
    return $this->key;
  }

}
