# TMGMT Ignore Fields

## Introduction
TMGMT Ignore Fields is a Drupal 10 module that extends the Translation Management Tool (TMGMT) by allowing administrators to specify certain fields that should be excluded from the translation process.

## Requirements
- Tested up to Drupal 11.1.6
- Translation Management Tool (TMGMT) module

## Installation
1. Download and install the module using Composer:
2. Enable the module via Drush or via the Drupal admin interface.

## Configuration
1. Navigate to `/admin/config/content/tmgmt-ignore-fields` or go to Configuration > Content authoring > Ignore Fields Settings
2. Check the fields (both base fields and configurable fields) that you want to exclude from translation
3. Click "Save configuration"
4. You have now globally excluded the selected fields from translation. This means that these fields will not be included in any translation jobs created using TMGMT.

## How It Works
The module overrides the default Content Entity Source plugin to filter out selected fields before they are sent for translation. This ensures that specified fields are consistently excluded from all translation jobs without modifying the original content structure.

## Maintainers

- Yorick Devleeschouwer - [yorickdv](http://drupal.org/u/yorickdv)

## License
This project is licensed under the GNU General Public License v2.0 or later.
