<?php

namespace Drupal\tmgmt_ignore_fields\Plugin\tmgmt\Source;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\tmgmt_content\Plugin\tmgmt\Source\ContentEntitySource;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Ignores certain content entity fields when extracting translatable data.
 */
class IgnoreFieldsContentEntitySource extends ContentEntitySource implements ContainerFactoryPluginInterface {

  /**
   * The config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new IgnoreFieldsContentEntitySource.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, ConfigFactoryInterface $config_factory) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('config.factory')
    );
  }

  /**
   * Extracts translatable data from the content entity.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The content entity.
   * @param array $entityRegistry
   *   Fixes compatibility with tmgmt_content.
   *
   * @return array
   *   The translatable data.
   */
  public function extractTranslatableData(ContentEntityInterface $entity, &$entityRegistry = []): array {
    $config = $this->configFactory->get('tmgmt_ignore_fields.settings');
    $ignore_fields = $config->get('ignore_fields') ?? [];

    $data = parent::extractTranslatableData($entity);

    foreach ($data as $key => $item) {
      if (in_array($key, $ignore_fields, TRUE)) {
        unset($data[$key]);
      }
    }

    return $data;
  }

}
