# Lara Translate Provider

**Lara Translate Provider** integrates Drupal’s Translation Management Tool (TMGMT) with the Lara translation service, letting site editors send content for high-quality translations and retrieve them without leaving Drupal.

## Features
- Implements a TMGMT translation provider plugin for Lara.
- Lets you send content or batches directly from Drupal to Lara’s translation pipeline.
- Automatically fetches completed translations and imports them into the site.
- Supports translation status updates (in progress, completed, errors).
- Leverages Lara’s context-aware translation model: Lara processes full documents (not isolated segments), preserving consistency, style, and meaning. ([laratranslate.com](https://laratranslate.com/about-lara))
- Offers style options (e.g. “Faithful”, “Fluid”, “Creative”) to match the tone of your content. ([laratranslate.com](https://laratranslate.com/about-lara))
- Suitable for sites that want to centralize translation workflows without manual export/import overhead.

**Use cases include:**
- A multilingual content site wanting professional-quality translation service integrated into Drupal.
- Projects where maintaining tone, consistency, and clarity is critical (marketing, legal, technical content).
- Teams wanting to automate translation submission, tracking, and ingestion.

## Post-Installation
1. Enable the **Lara Translate Provider** module and ensure **TMGMT** is active.
2. Go to *Translation Management → Providers*.
3. Create a Lara provider instance by entering your Lara API credentials.
4. Optionally configure defaults (e.g. preferred style, fallback handling).
5. Use the TMGMT interface (jobs, workflows) to submit content to Lara.
6. As translations finish, they are pulled back automatically (or manually, depending on settings).

Once installed, you don’t manage separate content types or fields — the module works via TMGMT’s existing workflows.
The main setup is in the provider configuration.
Users should also verify that content types, text formats, and languages are properly enabled for translation in Drupal core before sending to Lara.

## Additional Requirements
- [TMGMT (Translation Management Tool)](https://www.drupal.org/project/tmgmt) module.
- A valid **Lara API account** with access credentials.
- Access from your server to Lara’s API endpoints (network and firewall rules allowing).

## Similar projects
- [AI Translation Management (TMGMT)](https://www.drupal.org/project/ai_tmgmt) – integrates AI-powered translation using the AI module with providers like OpenAI, Ollama, and more.

**Similarities:** Like _AI Translation Management_, _Lara Translate Provider_ uses queue-based processing for translation jobs. Both modules process translation requests asynchronously during cron runs, allowing large jobs to be handled efficiently without blocking content operations or timing out.

**What differentiates Lara Translate Provider:** While _AI Translation Management_ supports multiple AI providers with customizable prompts and style tweaking, _Lara Translate Provider_ is built specifically for **[Lara](https://laratranslate.com/about-lara)**, which uses a context-aware translation engine that reads entire documents to preserve consistency and meaning, offers predefined style control (Faithful / Fluid / Creative), and "explains its translation choices" for transparency.

**What differentiates Lara Translate Provider:** it’s built specifically for **Lara**, which uses a context-aware translation engine that reads entire documents to preserve consistency and meaning, offers style control (Faithful / Fluid / Creative), and “explains its translation choices” for transparency. ([laratranslate.com](https://laratranslate.com/about-lara))

## Supporting this Module
Development support is welcome! You can:
- Contribute via Git / issues / patches / documentation
- Share feedback or bug reports
- Sponsor development through direct funding or organizational support

## Community Documentation
- Official Lara documentation / API reference: [laratranslate.com](https://laratranslate.com/about-lara)
