# Quick Start Guide: Queue-Based Translation Processing

## TL;DR

Translation jobs are now processed asynchronously via Drupal's queue system during cron runs.

## 5-Minute Setup

### 1. Test It
```bash
# Submit a translation job (via UI)
# Check queue
ddev drush queue:list

# Run cron
ddev drush cron

# Check results
ddev drush watchdog:show --type=tmgmt_laratranslate
```

## How It Works

```
Translation Job → Queue → Cron → Process → Complete
                    ↓
              (Automatic Retry if Failed)
```

## Troubleshooting

### Queue items not processing?
```bash
# Check if cron is running
ddev drush core:cron

# Check queue
ddev drush queue:list
```

### Timeouts or processing issues?
Check the logs and adjust cron frequency if needed.

## Monitoring

### Check Queue Status
**CLI**: `ddev drush queue:list`

### View Logs
**UI**: `/admin/reports/dblog` → Filter by "tmgmt_laratranslate"
**CLI**: `ddev drush watchdog:show --type=tmgmt_laratranslate`

### Log Messages You'll See

✅ **Success**:
```
Processing job item 123 from queue
Job 456 completed successfully
```

❌ **Error**:
```
Failed to process job item 123: Translation quota exceeded
```

## Key Benefits

- ✅ **Non-blocking**: Content saves immediately
- ✅ **Reliable**: Automatic retry on failure
- ✅ **Transparent**: Clear logs and status

## Need Help?

See detailed documentation:
- `doc/QUEUE_IMPLEMENTATION_COMPLETE.md` - Complete overview
- `doc/QUEUE_IMPLEMENTATION_PROPOSAL.md` - Technical details

---

That's it! Your translation system is now queue-based and production-ready. 🚀
