# Where to See Quota Error Messages

## Problem
You're not seeing quota error warnings in Drupal logs (watchdog).

## Solution
Quota error messages are now visible **directly in the TMGMT UI** on the job item, not just in logs.

## Where to Look

### 1. TMGMT Job Item Messages (Primary Location) ✅

**Path**:
- Go to: `/admin/tmgmt/jobs`
- Click on a job to view details
- Look at individual job items

**What you'll see**:
```
⚠️ Translation quota exceeded. Job item will be automatically retried when quota is available.
Error: You have exceeded your "api_translation_chars" quota
```

This message is added using `$job_item->addMessage()` which makes it visible in the TMGMT UI.

### 2. Job Item State ✅

**Path**: Same as above (`/admin/tmgmt/jobs`)

**What you'll see**:
- **State**: "Active" (not "Needs review")
- This indicates the item will be retried automatically

### 3. Queue Status ✅

**Via Drush**:
```bash
ddev drush queue:list
```

**What you'll see**:
```
tmgmt_laratranslate_worker: X items
```

Items remain in queue and will be retried on next cron run.

## Why Not in Drupal Logs?

The logging approach has been simplified:

1. **Job item messages** (visible in UI) - This is where users should look
2. **Queue worker handles retries** - Happens automatically in background
3. **No verbose segment-level logging** - Reduces log noise

## Testing

### 1. Trigger a quota error
- Use an account with exceeded quota
- Create/edit content with continuous translation enabled
- Or submit a manual translation job

### 2. Check the TMGMT UI
```
Navigate to: /admin/tmgmt/jobs
↓
Click on your job
↓
Look for job items in "Active" state
↓
Check the "Messages" section on the job item
↓
Should see: "Translation quota exceeded..."
```

### 3. Verify queue behavior
```bash
# Check queue has items
ddev drush queue:list

# Try to process (will fail due to quota but item stays queued)
ddev drush queue:run tmgmt_laratranslate_worker

# Check queue again - items should still be there
ddev drush queue:list
```

### 4. Verify auto-retry
```bash
# Wait for quota to refresh or increase quota

# Run cron (or queue manually)
ddev drush cron

# Check job items - should now be translated
# Navigate to: /admin/tmgmt/jobs and check status
```

## Expected Flow

```
1. Translation attempted
   ↓
2. Quota exceeded error occurs
   ↓
3. Job item message added (visible in UI)
   ↓
4. Job item stays "Active"
   ↓
5. Item re-queued
   ↓
6. Cron runs later
   ↓
7. If quota available: translation succeeds
   If quota still exceeded: retry again on next cron
```

## Key Points

✅ **User-visible messages**: Use TMGMT UI, not Drupal logs
✅ **Automatic retry**: No manual intervention needed
✅ **State stays Active**: Indicates automatic retry will happen
✅ **Queue persists items**: Items remain until successful

❌ **Don't expect**: Verbose watchdog/DBLog entries for every segment
❌ **Don't expect**: Job items in "Needs review" state (they stay "Active")

## Alternative: Check Logs (If Really Needed)

If you still want to check logs:

```bash
# Check TMGMT-related logs (not tmgmt_laratranslate specifically)
ddev drush watchdog:show --type=tmgmt --count=50

# Check for any errors in general
ddev drush watchdog:show --severity=Error --count=20
```

But the **TMGMT UI is the primary place** to check status and messages.
