<?php

declare(strict_types=1);

namespace Drupal\tmgmt_laratranslate\Trait;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Trait to add messages to forms.
 */
trait FormMessageTrait {

  /**
   * Adds a message to the form.
   *
   * @param array<array-key, mixed> $form
   *   The form array.
   * @param array<int|string, string> $element_keys
   *   The keys to use for the message element in the form array.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $message
   *   The message to display.
   * @param string $type
   *   The type of message. One of 'status', 'warning', 'error', or 'info'.
   *   Defaults to 'info'.
   */
  private function addMessage(array &$form, array $element_keys, TranslatableMarkup|string $message, string $type = 'info'): void {
    // Navigate to the correct nested location in the form.
    $target = &$form;
    foreach ($element_keys as $key) {
      $target = &$target[$key];
    }
    $target = [
      '#type' => 'markup',
      '#markup' => '<div class="messages__content">' . $message . '</div>',
      '#prefix' => '<div class="messages-list"><div class="messages-list__wrapper"><div class="messages-list__item messages messages--' . $type . '">',
      '#suffix' => '</div></div></div>',
    ];
  }

}
