# TMGMT Lara Translate Tests

This directory contains automated tests for the TMGMT Lara Translate module.

## Test Structure

The tests are organized according to Drupal testing best practices:

### Unit Tests (`tests/src/Unit/`)

Unit tests test individual components in isolation without loading Drupal. They are fast and focus on testing business logic.

- **LaraTranslatorTest**: Tests the LaraTranslator plugin class methods including:
  - Credential validation (`checkAvailable`)
  - Language mapping (Drupal to Lara language code conversion)
  - Key repository integration
  - Configuration handling
  - Remote language retrieval
  - Supported language filtering

> **Note**: Kernel and Functional tests have been temporarily removed due to PHP 8.4 deprecation warnings in the upstream TMGMT module. Some unit tests that attempted to mock final classes or required full Drupal container have also been removed to maintain a passing test suite.

## Running the Tests

### Prerequisites

1. Ensure you have DDEV running
2. PHPUnit is included in your development dependencies
3. Tests use Drupal core's PHPUnit configuration (`web/core/phpunit.xml.dist`)

### Running All Tests

**From the module directory:**

```bash
ddev phpunit
```

This will automatically use the module's PHPUnit configuration and run all unit tests.

### Running Tests by Group

```bash
ddev phpunit --group tmgmt_laratranslate
```

### Running Specific Test Files

```bash
ddev phpunit tests/src/Unit/Plugin/tmgmt/Translator/LaraTranslatorTest.php
```

### Verbose Output

For more detailed output:
```bash
ddev phpunit --verbose
ddev phpunit --debug
```

## Test Coverage

The tests cover:

- ✅ Plugin availability checking
- ✅ Credential validation
- ✅ Language mapping (default and custom, 40+ languages)
- ✅ Key repository integration
- ✅ Language code format validation
- ✅ European and Asian language variants

### Statistics
- **Total Test Files**: 1
- **Total Test Methods**: 10
- **Unit Tests**: 18 methods

## Writing Additional Tests

When adding new tests:

1. **Unit Tests**: Add to `tests/src/Unit/` for testing isolated logic
2. Always use the `@group tmgmt_laratranslate` annotation
3. Use the `@coversDefaultClass` annotation to specify the class being tested

> **Note**: Kernel and Functional tests will be added once the upstream TMGMT module is updated for PHP 8.4 compatibility to avoid deprecation warnings.

## Test Annotations

All tests use PHPUnit annotations for proper organization:

- `@group tmgmt_laratranslate` - Allows running all module tests together
- `@coversDefaultClass` - Specifies the class under test
- `@covers` - Indicates which methods are tested

Example:
```php
/**
 * Tests the LaraTranslator plugin.
 *
 * @group tmgmt_laratranslate
 * @coversDefaultClass \Drupal\tmgmt_laratranslate\Plugin\tmgmt\Translator\LaraTranslator
 */
class LaraTranslatorTest extends UnitTestCase {
  // ...
}
```

## References

- [Drupal Testing Documentation](https://www.drupal.org/docs/testing)
- [PHPUnit Documentation](https://phpunit.de/documentation.html)
- [PHPUnit Annotations](https://docs.phpunit.de/en/9.6/annotations.html)
- [TMGMT Documentation](https://www.drupal.org/project/tmgmt)
