# Documentation Index

This directory contains comprehensive documentation for the TMGMT Lara Translate module, including the queue-based translation processing system.

## Quick Access

### 🚀 Getting Started
- **[QUICK_START.md](QUICK_START.md)** - 5-minute setup guide for queue processing

### 📋 Complete Implementation
- **[QUEUE_IMPLEMENTATION_COMPLETE.md](QUEUE_IMPLEMENTATION_COMPLETE.md)** - Full overview of the entire queue system

## Implementation Guides

### Phase Documentation
1. **[QUEUE_IMPLEMENTATION_PROPOSAL.md](QUEUE_IMPLEMENTATION_PROPOSAL.md)** - Original architecture proposal with diagrams
2. **[QUEUE_IMPLEMENTATION_PHASE1_COMPLETE.md](QUEUE_IMPLEMENTATION_PHASE1_COMPLETE.md)** - Core queue system (QueueWorker, integration)
3. **[QUEUE_IMPLEMENTATION_PHASE2_COMPLETE.md](QUEUE_IMPLEMENTATION_PHASE2_COMPLETE.md)** - Configuration UI and settings

### Technical Implementation
- **[HOOK_CRON_IMPLEMENTATION.md](HOOK_CRON_IMPLEMENTATION.md)** - Drupal 11 Hook class implementation details

## Problem Solving & Fixes

### Critical Fixes
- **[CRITICAL_FIX_CONTINUOUS_TRANSLATION_BLOCKING.md](CRITICAL_FIX_CONTINUOUS_TRANSLATION_BLOCKING.md)** - Fix for content save blocking on quota errors
- **[QUOTA_ERROR_HANDLING.md](QUOTA_ERROR_HANDLING.md)** - How quota errors are handled

### User Guidance
- **[WHERE_TO_SEE_QUOTA_ERRORS.md](WHERE_TO_SEE_QUOTA_ERRORS.md)** - Where to find error messages in the UI

## Other Documentation

- **[LANGUAGE_MAPPING.md](LANGUAGE_MAPPING.md)** - Language code mapping between Drupal and Lara Translate

## Document Organization by Topic

### For Site Administrators
Start here → **[QUICK_START.md](QUICK_START.md)**

Then read:
1. [QUEUE_IMPLEMENTATION_COMPLETE.md](QUEUE_IMPLEMENTATION_COMPLETE.md) - Understanding the system
2. [WHERE_TO_SEE_QUOTA_ERRORS.md](WHERE_TO_SEE_QUOTA_ERRORS.md) - Monitoring and troubleshooting

### For Developers
Start here → **[QUEUE_IMPLEMENTATION_COMPLETE.md](QUEUE_IMPLEMENTATION_COMPLETE.md)**

Then read:
1. [QUEUE_IMPLEMENTATION_PROPOSAL.md](QUEUE_IMPLEMENTATION_PROPOSAL.md) - Architecture overview
2. [HOOK_CRON_IMPLEMENTATION.md](HOOK_CRON_IMPLEMENTATION.md) - Cron hook details
3. [QUEUE_IMPLEMENTATION_PHASE1_COMPLETE.md](QUEUE_IMPLEMENTATION_PHASE1_COMPLETE.md) - QueueWorker plugin
4. [QUEUE_IMPLEMENTATION_PHASE2_COMPLETE.md](QUEUE_IMPLEMENTATION_PHASE2_COMPLETE.md) - Configuration UI

### For Troubleshooting
1. [QUICK_START.md](QUICK_START.md) - Common issues section
2. [WHERE_TO_SEE_QUOTA_ERRORS.md](WHERE_TO_SEE_QUOTA_ERRORS.md) - Finding error messages
3. [QUOTA_ERROR_HANDLING.md](QUOTA_ERROR_HANDLING.md) - Understanding error handling
4. [HOOK_CRON_IMPLEMENTATION.md](HOOK_CRON_IMPLEMENTATION.md) - Logging and monitoring

## Key Features Documented

### Queue Processing System
- ✅ Asynchronous translation processing
- ✅ Configurable items per cron run (1-100)
- ✅ Configurable timeout (10-300 seconds)
- ✅ Automatic retry on failure
- ✅ Multi-translator support
- ✅ Comprehensive logging

### Modern Drupal 11 Implementation
- ✅ Hook class pattern with `#[Hook('cron')]` attribute
- ✅ Dependency injection
- ✅ Type-safe PHP 8+ code
- ✅ Configuration entity integration

### Error Handling
- ✅ Non-blocking continuous translation
- ✅ Graceful quota error handling
- ✅ Job item messages for user visibility
- ✅ Detailed logging for debugging

## Documentation Standards

All documentation follows these standards:
- ✅ Markdown format
- ✅ Code examples with syntax highlighting
- ✅ Mermaid diagrams for architecture
- ✅ Step-by-step testing instructions
- ✅ Real-world configuration examples
- ✅ Troubleshooting sections

## Contributing

When adding new features:
1. Update relevant existing documentation
2. Create new documentation if needed
3. Update this index file
4. Include code examples
5. Add testing instructions

## Version History

- **October 2025**: Initial queue system implementation
  - Phase 1: Core queue system
  - Phase 2: Configuration UI
  - Phase 3: Drupal 11 Hook class implementation
  - Critical fix: Non-blocking continuous translation
  - Simplification: Removed max_retries parameter

## Support

For questions or issues:
1. Check [QUICK_START.md](QUICK_START.md) troubleshooting section
2. Review relevant technical documentation
3. Check Drupal logs: `/admin/reports/dblog`
4. Use drush: `ddev drush watchdog:show --type=tmgmt_laratranslate`

---

**Last Updated**: October 2025
**Module Version**: Compatible with Drupal 10 || 11
**Status**: ✅ Complete Documentation
