<?php

declare(strict_types=1);

namespace Drupal\tmgmt_laratranslate\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for tmgmt_laratranslate module.
 */
class TmgmtLaratranslateHooks {

  /**
   * The configuration object for tmgmt_laratranslate settings.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected ImmutableConfig $config;

  /**
   * Constructs a TmgmtLaratranslateHooks object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The configuration factory service.
   */
  public function __construct(
    protected readonly ConfigFactoryInterface $configFactory,
  ) {
    $this->config = $this->configFactory->get('tmgmt_laratranslate.settings');
  }

  /**
   * Implements hook_tmgmt_translatable_fields_alter().
   *
   * Alters the list of translatable fields for content entities before they
   * are processed by the TMGMT system.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The content entity being processed.
   * @param \Drupal\Core\Field\FieldDefinitionInterface[] $translatable_fields
   *   An array of translatable field definitions, keyed by field name.
   */
  #[Hook('tmgmt_translatable_fields_alter')]
  public function tmgmtTranslatableFieldsAlter(ContentEntityInterface $entity, array &$translatable_fields): void {
    $excluded_field_types = $this->config->get('excluded_field_types') ?? [];

    foreach ($translatable_fields as $field_name => $field_definition) {
      if (in_array($field_definition->getType(), $excluded_field_types, TRUE)) {
        unset($translatable_fields[$field_name]);
      }
    }
  }

}
