<?php

/**
 * @file
 * Contains \Drupal\lestrade_tmgmt_reverso\ReversoTranslatorUi.
 */

namespace Drupal\tmgmt_reverso;

use Drupal\tmgmt\TranslatorPluginUiBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Reverso translator UI.
 */
class ReversoTranslatorUi extends TranslatorPluginUiBase {

  /**
   * Configuration form Reverso
   *
   * @param array $form
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   * @return array
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    /** @var \Drupal\tmgmt\TranslatorInterface $translator */
    $translator = $form_state->getFormObject()->getEntity();
    $form['username'] = [
      '#type' => 'textfield',
      '#title' => t('Username'),
      '#required' => TRUE,
      '#default_value' => $translator->getSetting('username'),
      '#description' => t('Please enter your Reverso username.'),
    ];
    $form['password'] = [
      '#type' => 'textfield',
      '#title' => t('Password'),
      '#required' => TRUE,
      '#default_value' => $translator->getSetting('password'),
      '#description' => t('Please enter your Reverso password.'),
    ];
    $form['url'] = [
      '#type' => 'textfield',
      '#title' => t('Url'),
      '#required' => TRUE,
      '#default_value' => $translator->getSetting('url'),
      '#description' => t('Please enter Reverso endpoint.'),
    ];
    return parent::buildConfigurationForm($form, $form_state);
  }
}
