<?php

namespace Drupal\tmgmt_smartcat\Services;

use Drupal\tmgmt\TranslatorInterface;

class LocaleMapper
{
  /**
   * Maps Drupal language codes to Smartcat provider locales.
   *
   * @param string $locale
   *   The Drupal language code.
   * @param TranslatorInterface|null $translator
   *   The translator instance. If not provided, will try to get from plugin.
   * @return string
   *   The mapped provider locale or the original locale if no mapping exists.
   */
  public static function getProviderLocale(string $locale, TranslatorInterface $translator = null): string
  {
    // Get the locale mapping from TMGMT
    $mapping = $translator->getRemoteLanguagesMappings();

    // Return mapped locale or fallback to locale
    return $mapping[$locale] ?? $locale;
  }
}
