<?php

namespace Drupal\tmgmt_smartcat\Data;

class TranslatableItemSegment
{
    private string $key;

    private string $sourceValue;

    private string $existingTranslation;

    public function __construct(string $key, string $sourceValue, string $existingTranslation = '')
    {
        $this->key = $key;
        $this->sourceValue = $sourceValue;
        $this->existingTranslation = $existingTranslation;
    }

    public function getKey(): string
    {
        return $this->key;
    }

    public function setKey(string $key): TranslatableItemSegment
    {
        $this->key = $key;

        return $this;
    }

    public function getSourceValue(): string
    {
        return $this->sourceValue;
    }

    public function setSourceValue(string $sourceValue): TranslatableItemSegment
    {
        $this->sourceValue = $sourceValue;

        return $this;
    }

    public function getExistingTranslation(): string
    {
        return $this->existingTranslation;
    }

    public function setExistingTranslation(string $existingTranslation): TranslatableItemSegment
    {
        $this->existingTranslation = $existingTranslation;

        return $this;
    }

    public function toLocJson(): array
    {
        return [
            'id' => $this->key,
            'sourceText' => $this->sourceValue,
            'format' => 'auto',
            'existingTranslation' => $this->existingTranslation,
        ];
    }
}
