<?php

namespace Drupal\Tests\tmgmt_smartling_log_settings\Functional;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Tests\BrowserTestBase;

/**
 * Tests TmgmtSmartlingLogSettingsTest settings.
 *
 * @group tmgmt_smartling_log_settings_functional
 */
class TmgmtSmartlingLogSettingsTest extends BrowserTestBase {
  use StringTranslationTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['tmgmt_smartling_log_settings'];

  /**
   * Default theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $admin_user = $this->drupalCreateUser(['administer site configuration']);
    $this->drupalLogin($admin_user);
  }

  /**
   * Tests the tmgmt_smartling_log_settings settings page.
   */
  public function testValidSettingsNotEmptyConfig() {
    $this->drupalGet('admin/config/development/logging');
    $this->submitForm(['tmgmt_smartling_log_settings_severity_mapping' => "smartling_api: info\r\ntmgmt_smartling: notice"], $this->t('Save configuration')->render());
    $this->assertSession()->pageTextContains($this->t('The configuration options have been saved.')->render());
  }

  /**
   * Tests the tmgmt_smartling_log_settings settings page: empty config.
   */
  public function testValidSettingsEmptyConfig() {
    $this->drupalGet('admin/config/development/logging');
    $this->submitForm(['tmgmt_smartling_log_settings_severity_mapping' => ""], $this->t('Save configuration')->render());
    $this->assertSession()->pageTextContains($this->t('The configuration options have been saved.')->render());
  }

  /**
   * Tests the tmgmt_smartling_log_settings settings page: invalid yaml.
   */
  public function testSettingsInvalidYaml() {
    $this->drupalGet('admin/config/development/logging');
    $this->submitForm(['tmgmt_smartling_log_settings_severity_mapping' => "smartling_api: info\r\n- tmgmt_smartling: notice"], $this->t('Save configuration')->render());
    $this->assertSession()->pageTextContains($this->t('Config must be a valid yaml.')->render());
  }

  /**
   * Tests the tmgmt_smartling_log_settings settings page: not array.
   */
  public function testSettingsInvalidConfigNotArray() {
    $this->drupalGet('admin/config/development/logging');
    $this->submitForm(['tmgmt_smartling_log_settings_severity_mapping' => "smartling_api info"], $this->t('Save configuration')->render());
    $this->assertSession()->pageTextContains($this->t('Invalid config format.')->render());
  }

  /**
   * Tests the tmgmt_smartling_log_settings settings page: keys are not strings.
   */
  public function testSettingsInvalidConfigKeysAreNotStrings() {
    $this->drupalGet('admin/config/development/logging');
    $this->submitForm(['tmgmt_smartling_log_settings_severity_mapping' => "- smartling_api: info\r\n- tmgmt_smartling: notice"], $this->t('Save configuration')->render());
    $this->assertSession()->pageTextContains($this->t('Invalid config format.')->render());
  }

  /**
   * Tests the tmgmt_smartling_log_settings settings page: values are not strings.
   */
  public function testSettingsInvalidConfigOneOrMoreValuesAreNotValidSeverityLevel() {
    $this->drupalGet('admin/config/development/logging');
    $this->submitForm(['tmgmt_smartling_log_settings_severity_mapping' => "smartling_api: info\r\ntmgmt_smartling: severity_level"], $this->t('Save configuration')->render());
    $this->assertSession()->pageTextContains($this->t('Invalid config format.')->render());
  }

}
