<?php
namespace Drupal\tmgmt_smartling\Context;

use Drupal\tmgmt\Entity\JobItem;
use \Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\tmgmt_smartling\Plugin\tmgmt\Translator\SmartlingTranslator;

class TranslationJobToUrl {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  public function __construct(EntityTypeManagerInterface $entity_type_manager, ModuleHandlerInterface $module_handler) {
    $this->entityTypeManager = $entity_type_manager;
    $this->moduleHandler = $module_handler;
  }

  /**
   * Converts TMGMTJobItem into Url where that item can be found on the page.
   *
   * @var JobItem $job_item
   *   translation job item
   * @return string
   */
  public function convert(JobItem $job_item) {
    if (!$job_item->hasTranslator() || !($job_item->getTranslator()->getPlugin() instanceof SmartlingTranslator)) {
      return '';
    }

    try {
      $entity_type = $job_item->getItemType();
      $id = $job_item->getItemId();
      $entity = $this->entityTypeManager->getStorage($entity_type)->load($id);

      if (isset($entity->smartling_context_url) && !empty($entity->smartling_context_url)) {
        $url = $entity->smartling_context_url;
      }
      else {
        $source_url = $job_item->getSourceUrl();
        $url = empty($source_url) ? '' : $source_url->setAbsolute()->toString();
      }
    } catch (\Exception $e) {
      $url = '';
    }

    $cloned_item = clone $job_item;

    $this->moduleHandler->alter('tmgmt_smartling_context_url', $url, $cloned_item);

    return $url;
  }
}
