<?php

namespace Drupal\Tests\tmgmt_smartling\Functional;

use Drupal\Tests\Traits\Core\CronRunTrait;

/**
 * Context tests.
 *
 * @group tmgmt_smartling_functional
 */
class ContextTest extends SmartlingTestBase {

  use CronRunTrait;

  /**
   * Test manual context sending.
   */
  public function testManualContextSending() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $translator = $this->setUpSmartlingProviderSettings($this->smartlingPluginProviderSettings);
      $job = $this->requestTranslationForNode($this->testNodeId, $this->targetLanguage, $translator);
      $fileName = $job->getTranslatorPlugin()->getFileName($job);
      $this->drupalGet('admin/tmgmt/job_items', [
        'query' => [
          'state' => 'All',
          'source_language' => 'All',
          'target_language' => 'All',
        ],
      ]);
      $this->submitForm([
        'action' => 'tmgmt_smartling_send_context',
        'tmgmt_job_item_bulk_form[0]' => 'WyJ1bmQiLCIxIl0=',
      ], $this->t('Apply to selected items')->render());
      $this->submitForm([], $this->t('Send Context to Smartling')->render());
      $this->drupalGet('admin/reports/dblog');
      $this->assertSession()->responseContains(t('Context upload for file @filename completed successfully.', ['@filename' => $fileName]));
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

  /**
   * Test context sending by cron.
   */
  public function testContextSendingByCron() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $translator = $this->setUpSmartlingProviderSettings($this->smartlingPluginProviderSettings);
      $job = $this->requestTranslationForNode($this->testNodeId, $this->targetLanguage, $translator);
      $fileName = $job->getTranslatorPlugin()->getFileName($job);
      $this->cronRun();
      $this->drupalGet('admin/reports/dblog');
      $this->assertSession()->responseContains(t('Context upload for file @filename completed successfully.', ['@filename' => $fileName]));
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

  /**
   * Test Smartling context debugger: show context.
   */
  public function testSmartlingContextDebuggerShowContext() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      global $base_url;

      $this->drupalGet('admin/tmgmt/smartling-context-debug');
      $this->submitForm([
        'do_direct_output' => TRUE,
        'url' => 'https://www.smartling.com',
      ], $this->t('Test context')->render());
      $this->assertSession()->responseContains("Smartling, Inc.");
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

  /**
   * Test Smartling context debugger: no available configs.
   */
  public function testSmartlingContextDebuggerFormNoAvailableConfigs() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $smartling_provider_configs = \Drupal::getContainer()
        ->get('tmgmt_smartling.smartling_config_manager')
        ->getAvailableConfigs();

      foreach ($smartling_provider_configs as $smartling_provider_config) {
        \Drupal::configFactory()->getEditable(
          $smartling_provider_config->getName()
        )->delete();
      }

      $this->drupalGet('admin/tmgmt/smartling-context-debug');
      $this->assertSession()->responseContains('No Smartling configs found. Please create Smartling config first');
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

  /**
   * Test Smartling context debugger: send context.
   */
  public function testSmartlingContextDebuggerSendContext() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      global $base_url;

      // Workaround: TmgmtSmartlingContextDebugForm::submitForm() uses global
      // config not provider config:
      // \Drupal::config('tmgmt.translator.smartling')->get('settings');
      $this->drupalGet('admin/tmgmt/translators/manage/smartling');
      $this->submitForm($this->smartlingPluginProviderSettings, $this->t('Save')->render());

      $translator = $this->setUpSmartlingProviderSettings($this->smartlingPluginProviderSettings);
      $job = $this->requestTranslationForNode($this->testNodeId, $this->targetLanguage, $translator);
      $fileName = $job->getTranslatorPlugin()->getFileName($job);
      $this->checkGeneratedFile($fileName, $this->testNodeTitle);

      $this->drupalGet('admin/tmgmt/smartling-context-debug');
      $this->submitForm([
        'do_direct_output' => FALSE,
        'filename' => $fileName,
        'url' => $base_url . '/node/' . $this->testNodeId,
      ], $this->t('Test context')->render());
      $this->assertSession()->responseNotContains($this->testNodeTitle);
      $this->assertSession()->responseNotContains($this->testNodeBody);
      $this->assertSession()->responseContains('Smartling response');
      $this->drupalGet('admin/reports/dblog');
      $this->assertSession()->responseContains(t('Context upload for file @filename completed successfully.', ['@filename' => $fileName]));
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

  /**
   * Test override context css class.
   *
   * We must not set "sl-override-context" class for context because it causes
   * huge load on context service.
   */
  public function testOverrideContextOption() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $translator = $this->setUpSmartlingProviderSettings($this->smartlingPluginProviderSettings);
      $job = $this->requestTranslationForNode($this->testNodeId, $this->targetLanguage, $translator);
      $fileName = $job->getTranslatorPlugin()->getFileName($job);
      $this->drupalGet('admin/tmgmt/job_items', [
        'query' => [
          'state' => 'All',
          'source_language' => 'All',
          'target_language' => 'All',
        ],
      ]);
      $this->submitForm([
        'action' => 'tmgmt_smartling_send_context',
        'tmgmt_job_item_bulk_form[0]' => 'WyJ1bmQiLCIxIl0=',
      ], $this->t('Apply to selected items')->render());
      $this->submitForm([], $this->t('Send Context to Smartling')->render());

      // Context files are now deleted after upload, so we read from state
      // where the content is stored for testing purposes.
      $fileName = str_replace('.', '_', $fileName);
      $state_key = 'tmgmt_smartling_test.context_html.' . $fileName;
      $content = \Drupal::state()->get($state_key);

      $this->assertNotEmpty($content, 'Context HTML content should be available in state.');
      $this->assertTrue(strpos($content, 'class="sl-override-context"') === FALSE);
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }
}
