<?php

namespace Drupal\Tests\tmgmt_smartling\Functional;

/**
 * Lock fields tests.
 *
 * @group tmgmt_smartling_functional
 */
class LockFieldsTest extends SmartlingTestBase {

  /**
   * Test field locking.
   *
   * 1. Translate node into FR and DE.
   * 2. Lock title for FR.
   * 3. Lock body for DE.
   * 4. Download updated translations.
   * 5. FR: only body updated.
   * 6. DE: only title updated.
   * 7. Unlock all fields for FR.
   * 8. Unlock all fields for DE.
   * 9. Download updated translations.
   * 10. FR and DE are updated as well.
   */
  public function testFieldLockingLogic() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $this->drupalGet('/admin/tmgmt/translators/manage/smartling');
      $this->submitForm([
        'auto_accept' => $this->smartlingPluginProviderSettings['auto_accept'],
        'settings[project_id]' => $this->smartlingPluginProviderSettings['settings[project_id]'],
        'settings[user_id]' => $this->smartlingPluginProviderSettings['settings[user_id]'],
        'settings[token_secret]' => $this->smartlingPluginProviderSettings['settings[token_secret]'],
        'settings[contextUsername]' => $this->smartlingPluginProviderSettings['settings[contextUsername]'],
        'settings[retrieval_type]' => $this->smartlingPluginProviderSettings['settings[retrieval_type]'],
      ], 'Save');

      $this->drupalGet('admin/tmgmt/extension-settings');
      $this->submitForm([
        'do_track_changes' => FALSE,
      ], $this->t('Save configuration')->render());

      $this->drupalGet("node/add/translatable_node");
      $this->submitForm([
        'title[0][value]' => 'test title',
        'body[0][value]' => 'test body',
        'langcode[0][value]' => 'en',
      ], $this->t('Save')->render());

      $nid = 4;

      // 1. Translate node into FR and DE.
      $this->drupalGet('/admin/tmgmt/sources');
      $this->submitForm([
        "items[$nid]" => $nid,
      ], $this->t('Request translation')->render());

      $this->submitForm([
        'target_language' => 'fr',
        'settings[create_new_job_tab][name]' => 'Drupal TMGMT connector test FR ' . mt_rand(),
        'settings[create_new_job_tab][due_date][date]' => (date("Y") + 1) . '-12-12',
        'settings[create_new_job_tab][due_date][time]' => '12:12',
        'settings[create_new_job_tab][authorize]' => TRUE,
        'settings[smartling_users_time_zone]' => 'Europe/Kyiv',
      ], $this->t('Submit to provider')->render());

      $this->drupalGet('/admin/tmgmt/sources');
      $this->submitForm([
        "items[$nid]" => $nid,
      ], $this->t('Request translation')->render());

      $this->submitForm([
        'target_language' => 'de',
        'settings[create_new_job_tab][name]' => 'Drupal TMGMT connector test DE ' . mt_rand(),
        'settings[create_new_job_tab][due_date][date]' => (date("Y") + 1) . '-12-12',
        'settings[create_new_job_tab][due_date][time]' => '12:12',
        'settings[create_new_job_tab][authorize]' => TRUE,
        'settings[smartling_users_time_zone]' => 'Europe/Kyiv',
      ], $this->t('Submit to provider')->render());

      $this->drupalGet("admin/tmgmt/jobs/1");
      $this->submitForm([], $this->t('Download')->render());

      $this->drupalGet("admin/tmgmt/jobs/2");
      $this->submitForm([], $this->t('Download')->render());

      $this->drupalGet("node/$nid/edit");
      $this->assertSession()->responseNotContains('Smartling management');
      $this->assertSession()->responseNotContains('Lock fields');
      $this->assertSession()->statusCodeEquals(200);

      $this->drupalGet("fr/node/$nid/edit");
      $this->assertSession()->responseContains('Smartling management');
      $this->assertSession()->responseContains('Lock fields');
      $this->assertSession()->checkboxNotChecked('locked_fields[title]');
      $this->assertSession()->checkboxNotChecked('locked_fields[body]');
      $this->assertSession()->statusCodeEquals(200);

      $this->drupalGet("de/node/$nid/edit");
      $this->assertSession()->responseContains('Smartling management');
      $this->assertSession()->responseContains('Lock fields');
      $this->assertSession()->checkboxNotChecked('locked_fields[title]');
      $this->assertSession()->checkboxNotChecked('locked_fields[body]');
      $this->assertSession()->statusCodeEquals(200);

      // 2. Lock title for FR.
      $this->drupalGet("fr/node/$nid/edit");
      $this->submitForm([
        'title[0][value]' => 'Manually edited title',
        'locked_fields[title]' => 'title',
      ], $this->t('Save (this translation)')->render());

      $this->drupalGet("fr/node/$nid/edit");
      $this->assertSession()->checkboxChecked('locked_fields[title]');
      $this->assertSession()->checkboxNotChecked('locked_fields[body]');
      $this->assertSession()->statusCodeEquals(200);

      // 3. Lock body for DE.
      $this->drupalGet("de/node/$nid/edit");
      $this->submitForm([
        'body[0][value]' => 'Manually edited body',
        'locked_fields[body]' => 'body',
      ], $this->t('Save (this translation)')->render());

      $this->drupalGet("de/node/$nid/edit");
      $this->assertSession()->checkboxNotChecked('locked_fields[title]');
      $this->assertSession()->checkboxChecked('locked_fields[body]');
      $this->assertSession()->statusCodeEquals(200);

      // 4. Download updated translations.
      $this->drupalGet("node/$nid/edit");
      $this->submitForm([
        'title[0][value]' => 'test title new',
        'body[0][value]' => 'test body new',
      ], $this->t('Save (this translation)')->render());

      $this->drupalGet('/admin/tmgmt/sources');
      $this->submitForm([
        "items[$nid]" => $nid,
      ], $this->t('Request translation')->render());

      $this->submitForm([
        'target_language' => 'fr',
        'settings[create_new_job_tab][name]' => 'Drupal TMGMT connector test FR ' . mt_rand(),
        'settings[create_new_job_tab][due_date][date]' => (date("Y") + 1) . '-12-12',
        'settings[create_new_job_tab][due_date][time]' => '12:12',
        'settings[create_new_job_tab][authorize]' => TRUE,
        'settings[smartling_users_time_zone]' => 'Europe/Kyiv',
      ], $this->t('Submit to provider')->render());

      $this->drupalGet('/admin/tmgmt/sources');
      $this->submitForm([
        "items[$nid]" => $nid,
      ], $this->t('Request translation')->render());

      $this->submitForm([
        'target_language' => 'de',
        'settings[create_new_job_tab][name]' => 'Drupal TMGMT connector test DE ' . mt_rand(),
        'settings[create_new_job_tab][due_date][date]' => (date("Y") + 1) . '-12-12',
        'settings[create_new_job_tab][due_date][time]' => '12:12',
        'settings[create_new_job_tab][authorize]' => TRUE,
        'settings[smartling_users_time_zone]' => 'Europe/Kyiv',
      ], $this->t('Submit to provider')->render());

      $this->drupalGet("admin/tmgmt/jobs/3");
      $this->submitForm([], $this->t('Download')->render());

      $this->drupalGet("admin/tmgmt/jobs/4");
      $this->submitForm([], $this->t('Download')->render());

      // 5. FR: only body updated.
      $this->drupalGet("fr/node/$nid");
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->responseContains('Manually edited title');
      $this->assertSession()->responseContains('[t~ést ~bódý ~ñéw]');

      // 6. DE: only title updated.
      $this->drupalGet("de/node/$nid");
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->responseContains('[t~ést t~ítlé ~ñéw]');
      $this->assertSession()->responseContains('Manually edited body');

      // 7. Unlock all fields for FR.
      $this->drupalGet("fr/node/$nid/edit");
      $this->submitForm([
        'locked_fields[title]' => FALSE,
        'locked_fields[body]' => FALSE,
      ], $this->t('Save (this translation)')->render());

      // 8. Unlock all fields for DE.
      $this->drupalGet("de/node/$nid/edit");
      $this->submitForm([
        'locked_fields[title]' => FALSE,
        'locked_fields[body]' => FALSE,
      ], $this->t('Save (this translation)')->render());

      // 9. Download updated translations.
      $this->drupalGet("node/$nid/edit");
      $this->submitForm([
        'title[0][value]' => 'test title brand new',
        'body[0][value]' => 'test body brand new',
      ], $this->t('Save (this translation)')->render());

      $this->drupalGet('/admin/tmgmt/sources');
      $this->submitForm([
        "items[$nid]" => $nid,
      ], $this->t('Request translation')->render());

      $this->submitForm([
        'target_language' => 'fr',
        'settings[create_new_job_tab][name]' => 'Drupal TMGMT connector test FR ' . mt_rand(),
        'settings[create_new_job_tab][due_date][date]' => (date("Y") + 1) . '-12-12',
        'settings[create_new_job_tab][due_date][time]' => '12:12',
        'settings[create_new_job_tab][authorize]' => TRUE,
        'settings[smartling_users_time_zone]' => 'Europe/Kyiv',
      ], $this->t('Submit to provider')->render());

      $this->drupalGet('/admin/tmgmt/sources');
      $this->submitForm([
        "items[$nid]" => $nid,
      ], $this->t('Request translation')->render());

      $this->submitForm([
        'target_language' => 'de',
        'settings[create_new_job_tab][name]' => 'Drupal TMGMT connector test DE ' . mt_rand(),
        'settings[create_new_job_tab][due_date][date]' => (date("Y") + 1) . '-12-12',
        'settings[create_new_job_tab][due_date][time]' => '12:12',
        'settings[create_new_job_tab][authorize]' => TRUE,
        'settings[smartling_users_time_zone]' => 'Europe/Kyiv',
      ], $this->t('Submit to provider')->render());

      $this->drupalGet("admin/tmgmt/jobs/5");
      $this->submitForm([], $this->t('Download')->render());

      $this->drupalGet("admin/tmgmt/jobs/6");
      $this->submitForm([], $this->t('Download')->render());

      // 10. FR and DE are updated as well.
      $this->drupalGet("fr/node/$nid");
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->responseContains('[t~ést t~ítlé ~bráñ~d ñéw]');
      $this->assertSession()->responseContains('[t~ést b~ódý b~ráñd ~ñéw]');

      $this->drupalGet("de/node/$nid");
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->responseContains('[t~ést t~ítlé ~bráñ~d ñéw]');
      $this->assertSession()->responseContains('[t~ést b~ódý b~ráñd ~ñéw]');
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }
}
