<?php

namespace Drupal\tmgmt_smartling\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\tmgmt_extension_suit\Utils\FlowScheduler;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\Response;

class PushCallbackAttachmentController extends ControllerBase {

  /**
   * @var FlowScheduler
   */
  protected $flowScheduler;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('tmgmt_extension_suit.utils.flow_scheduler')
    );
  }

  public function __construct(FlowScheduler $flow_scheduler) {
    $this->flowScheduler = $flow_scheduler;
  }

  public function callback(Request $request) {
    $job_id = $request->get('job');
    $file_id = $request->get('file');

    // Check if we have a job.
    if (!$job_id) {
      throw new NotFoundHttpException();
    }

    // Check if we have a file.
    if (!$file_id) {
      throw new NotFoundHttpException();
    }

    // Check if we have fileUri and locale.
    if (!($request->get('fileUri')) || !($request->get('locale'))) {
      throw new NotFoundHttpException();
    }

    $this->flowScheduler->scheduleDownload($job_id, NULL, $file_id);

    return new Response('OK');
  }

}
