<?php

namespace Drupal\Tests\tmgmt_smartling\Functional;

/**
 * Basic flow tests.
 *
 * @group tmgmt_smartling_functional
 */
class BaseFlowTest extends SmartlingTestBase {

  /**
   * Test upload and download translation.
   */
  public function testUploadFileAndDownloadTranslation() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $translator = $this->setUpSmartlingProviderSettings($this->smartlingPluginProviderSettings);
      $job = $this->requestTranslationForNode($this->testNodeId, $this->targetLanguage, $translator);
      $fileName = $job->getTranslatorPlugin()->getFileName($job);
      $this->checkGeneratedFile($fileName, $this->testNodeTitle);

      // Check fr node title before translation (should be same as en title).
      $this->drupalGet("$this->targetLanguage/node/$this->testNodeId");
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->pageTextContains($this->testNodeTitle);

      // Download translated file.
      $this->downloadAndCheckTranslatedFile($job->id(), $fileName);

      // Check translation.
      $this->drupalGet("$this->targetLanguage/node/$this->testNodeId");
      $this->assertSession()->statusCodeEquals(200);
      $this->assertSession()->pageTextNotContains($this->testNodeTitle);
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

  /**
   * Test request translation when there is one provider in a list.
   *
   * There was an issue when there is only one provider in the list
   * and system requests translation without checkout settings form.
   */
  public function testRequestTranslationWhenOneProviderAvailable() {
    if (!empty($this->smartlingPluginProviderSettings)) {
      $this->drupalGet('/admin/tmgmt/translators/manage/smartling');
      $this->submitForm($this->smartlingPluginProviderSettings, $this->t('Save')->render());
      $this->drupalGet('/admin/tmgmt/translators/manage/local/delete');
      $this->submitForm([], $this->t('Delete')->render());
      $this->drupalGet('/admin/tmgmt/translators/manage/file/delete');
      $this->submitForm([], $this->t('Delete')->render());
      $this->drupalGet('/admin/tmgmt/translators/manage/test_translator/delete');
      $this->submitForm([], $this->t('Delete')->render());
      $this->drupalGet('/admin/tmgmt/sources');

      $this->submitForm([
        'items[1]' => 1,
        'target_language' => 'de',
      ], $this->t('Request translation')->render());

      $this->assertSession()->pageTextContains('One job needs to be checked out.');
      $this->assertSession()->pageTextContains('Create new job');
      $this->assertSession()->pageTextContains('Add to job');
    }
    else {
      $this->fail("Smartling settings file for simpletests not found.");
    }
  }

}
