<?php

namespace Drupal\tmgmt_supertext_ai;

use Drupal\tmgmt\TranslatorPluginUiBase;
use Drupal\Core\Form\FormStateInterface;
use GuzzleHttp\Exception\ClientException;

/**
 * Supertext translator UI.
 */
class SupertextAITranslatorUi extends TranslatorPluginUiBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);
    /** @var \Drupal\tmgmt\TranslatorInterface $translator */
    $translator = $form_state->getFormObject()->getEntity();

    $form['api_key'] = [
      '#type' => 'textarea',
      '#title' => t('API key'),
      '#required' => TRUE,
      '#default_value' => $translator->getSetting('api_key'),
      '#description' => t('Please enter the API key. You can create it in the Supertext <a target="_blank" href="@url">Cockpit</a>', [
        '@url' => 'https://www.supertext.com/cockpit/api',
      ]),
    ];

    $form['api_server'] = [
      '#type' => 'select',
      '#title' => $this->t('API server'),
      '#default_value' => $translator->getSetting('api_server'),
      '#options' => [
        'live' => $this->t('Live'),
        'staging' => $this->t('Development'),
        'testing' => $this->t('Testing'),
        'other' => $this->t('Other ...'),
      ],
    ];

    $form['api_server_other'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Other API server url'),
      '#states' => [
        'visible' => [
          ':input[name="settings[api_server]"]' => ['value' => 'other'],
        ],
        'required' => [
          ':input[name="settings[api_server]"]' => ['value' => 'other'],
        ],
      ],
    ];


    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $values = $form_state->getValue('settings');
    /** @var \Drupal\tmgmt\TranslatorInterface $translator */
    $translator = $form_state->getFormObject()->getEntity();

    $translator->setSetting('api_key', $values['api_key']);
    $translator->setSetting('api_server', $values['api_server']);
    $translator->setSetting('api_server_other', $values['api_server_other']);

    try {
      $dummy_data = new SupertextAiData('en', 'de-CH');
      $dummy_data->addText(1, 'Lama lama lama');
      $data = iterator_to_array($dummy_data);
      $translator->getPlugin()->supertextHttpRequest('text/quote', $translator, array_shift($data));
    }
    catch (\Exception $e) {
      $form_state->setError($form['plugin_wrapper']['settings'], $this->t("Checking credentials failed because: @error", [
        '@error' => $e->getMessage(),
      ]));
    }
  }

}
