# Tolgee TMGMT Provider

This module provides a **Tolgee** translator plugin for the Drupal **Translation Management Tool (TMGMT)** module.
It enables a robust, automated "Continuous Translation" workflow between Drupal and the Tolgee platform (https://tolgee.io).

## Key Features

* **Robust JSON Export**: Uses Tolgee's native JSON export format to strictly preserve translation keys and metadata, bypassing fragile XLIFF header limitations.
* **Continuous Translation (Automation)**:
    * **Auto-Push**: Automatically uploads new content (Unprocessed jobs) to Tolgee via Cron.
    * **Auto-Pull**: Automatically fetches completed translations (Active jobs) via Cron.
    * **Auto-Accept**: Optional setting to automatically approve imported translations, enabling zero-click publishing.
* **Bandwidth Efficiency**: Implements **HTTP Conditional Requests (ETags)**. If translations haven't changed in Tolgee, the module skips downloading and parsing, making frequent Cron polling extremely cheap and efficient.
* **Manual Control**: "Pull from Tolgee" button for on-demand synchronization.

## Installation

1.  Install the module via Composer:
    ```bash
    composer require drupal/tmgmt_tolgee
    ```
2.  Enable the module:
    ```bash
    drush en tmgmt_tolgee
    ```
3.  Ensure dependencies (`tmgmt`, `key`, `guzzle`, `tagify`) are enabled.

## Configuration

### 1. Configure API Key
1.  Go to **Configuration > System > Keys** (`/admin/config/system/keys`).
2.  Add a new Key (Type: Authentication/String).
3.  Value: Your Tolgee API Key (from Project Settings > API Keys).

### 2. Add Translator
1.  Go to **Translation > Providers** (`/admin/tmgmt/translators`).
2.  Add Provider.
3.  **Label**: "Tolgee".
4.  **Provider Plugin**: `Tolgee Translator`.
5.  **Settings**:
    * **Base URL**: `https://app.tolgee.io` (or your self-hosted instance URL).
    * **API Key**: Select the Key created in step 1.
    * **Project ID**: Required if using a Personal Access Token (PAT). Optional for Project API Keys.
    * **Auto Sync**: Check this box to enable **Cron Automation** (Auto-Push/Pull).
    * **Auto Accept**: Check this box to automatically accept/publish translations upon import.

## Compatibility & Tiers

### Cloud vs. Self-Hosted
This module is fully compatible with both **Tolgee Cloud** (`app.tolgee.io`) and **Self-Hosted** instances.
* **Cloud**: Use the default Base URL `https://app.tolgee.io`.
* **Self-Hosted**: Enter your custom instance URL (e.g., `https://tolgee.mycompany.com`) in the provider settings.

### Free vs. Business/Enterprise
The module is designed to work with **all Tolgee pricing tiers**, including the Free/Open Source Community edition.
* **No Webhooks Required**: It uses an active **Polling** mechanism (via Cron) rather than passive Webhooks. This ensures compatibility with tiers that do not support webhooks or environments behind firewalls.
* **API Rate Limits**: The **ETag** efficiency feature is specifically implemented to respect API usage limits on Cloud plans by avoiding unnecessary data transfer.

## Advanced Features

### Automatic & Dynamic Namespacing
To keep your translations organized in Tolgee, the module attempts to automatically detect the "context" or **Namespace** of the exported content.

#### Namespace Mapping (Dynamic UI)
You can define your own rules in the Provider Settings > **Namespace Mapping Rules**.
* **Rows**: Each row defines a target Namespace (e.g., `content`, `auth`).
* **Sources**: Use the **Entity Types** field to select one or multiple sources (Sources). This field supports auto-complete/tagged selection (e.g., type "node", "user").
* **Add Another**: Click "Add another mapping" to create a new rule.
* **Remove**: Click the `×` button to remove a rule.

#### Built-in Defaults (Fallback)
If no mapping is found for a specific Item Type, the module falls back to these defaults:

| Content Type | Namespace | Logic |
| :--- | :--- | :--- |
| **Menus** | `navigation` | Detected if the item is a Menu Link or label contains "menu". |
| **Auth** | `auth` | Detected for User entities, Login/Register forms, or "account" labels. |
| **Forms** | `forms` | Webforms, Contact Messages, or Field Config. |
| **Content** | `content` | Nodes, Media, Taxonomy, Custom Blocks. |
| **Actions** | `actions` | Single-word verbs like "Save", "Edit", "Delete". |

### Tagging Strategy
The module creates tags to help you filter and manage keys in the Tolgee Platform:
1.  **Job Tag**: `tmgmt-job-[ID]` (e.g., `tmgmt-job-123`). This allows you to find all keys associated with a specific Drupal job.
2.  **Source Tag**: `source-[LANG]` (e.g., `source-en`). Indicates the origin language.
3.  **Custom Tags**: You can add arbitrary comma-separated tags in the Job settings before submission.

## Technical Details

* **Export Format**: Requesting `format=JSON` & `zip=true` from Tolgee API.
* **Key Mapping**: Directly maps the JSON Key Name to the Drupal Source Data, ensuring 100% metadata fidelity.
* **State API**: Stores ETag values in `tmgmt_tolgee.etag.[job_id]` to track versioning.