<?php

namespace Drupal\Tests\tmgmt_tolgee\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests the Tolgee integration module setup.
 *
 * @group tmgmt_tolgee
 */
class TolgeeIntegrationTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'tmgmt',
    'tmgmt_file',
    'key',
    'file',
    'tmgmt_tolgee',
    'user',
    'system',
  ];

  /**
   * Tests that the translator plugin is discovered.
   */
  public function testPluginDiscovery() {
    $manager = $this->container->get('plugin.manager.tmgmt.translator');
    $definitions = $manager->getDefinitions();
    
    $this->assertArrayHasKey('tolgee', $definitions, 'Tolgee translator plugin found.');
    $this->assertEquals('Tolgee Translator', $definitions['tolgee']['label'], 'Plugin label is correct.');
  }

}
