# Changelog

All notable changes to this project will be documented in this file.

## [1.1.0] - 2026-01-10

### Added
- **Reverse Sync Submodule**: New submodule (`tmgmt_tolgee_reverse_sync`) enabling a bidirectional workflow. Local Drupal edits now trigger a "Needs Review" state and can be pushed back to Tolgee upon approval.
- **Scalability**: Implemented **Job Pagination** (200 items/run) and **Cron Batching** (20 jobs/run) to support massive datasets (e.g., 5000+ term vocabularies) without timeouts.
- **Persistent Key Mapping (Critical Fix)**: Eliminated the inclusion of TMGMT Job IDs in translation keys (a v1.0.0 flaw that caused duplication). Keys are now purely content-based (e.g., `entity:id][field]`), ensuring that the same content always maps to the same key in Tolgee, regardless of which job processes it.
- **Troubleshooting Guide**: Added comprehensive troubleshooting section to README.

### Changed
- **Export Format**: Switched from ZIP to **JSON** export (`zip=false`) to correct ETag generation. This ensures `304 Not Modified` responses work correctly, significantly reducing API bandwidth usage.
- **Change Detection**: Refined `filterUnchangedData` to strictly ignore metadata changes (timestamps, origin tags), preventing phantom "Needs Review" flags on identical content.
- **Logging**: Reduced log verbosity by removing redundant "Push Success" and "Skipped" messages.
- **Config**: Added "Allow Review and Push" safety setting to prevent accidental overwrites of remote data.

### Fixed
- Fixed an issue where "Auto Accept" would not correctly force a review state when disabled.
- Fixed a regression where Tolgee API fallbacks (Source text returned as Translation) could overwrite valid local translations.
- Resolved "Job Tag" clutter by removing the feature in favor of cleaner `source-[LANG]` tags.
