# Tolgee TMGMT Provider
This module provides a **Tolgee** translator plugin for the Drupal Translation Management Tool (TMGMT) module. It enables a robust, automated workflow between Drupal and the Tolgee platform (https://tolgee.io), utilizing a persistent key mapping strategy to ensure data integrity.

## Key Features
* **Persistent Key Mapping (New in v1.1.0):** Uses standard keys (e.g., `entity:id][field][delta][property`) as the unique identifier in Tolgee. This prevents key duplication and ensures that a single piece of content in Drupal always maps to the same key in Tolgee.

* **Reverse Sync Submodule:** An automated "Continuous Translation" loop. When content is updated locally in Drupal, the module automatically reverts the associated Job Item to "Needs Review" and pushes the update back to Tolgee upon approval.

* **Continuous Translation (Automation)**:
    * **Auto-Push**: Automatically uploads new content (Unprocessed jobs) to Tolgee via Cron.
    * **Auto-Pull**: Automatically fetches completed translations (Active jobs) via Cron.
    * **Auto-Accept**: Optional setting to automatically approve imported translations, enabling zero-click publishing.
* **Bandwidth Efficiency:** Implements HTTP Conditional Requests (ETags). If translations haven't changed in Tolgee, the module skips downloading and parsing, respecting API rate limits.

* **Transactional Reliability:** Remote pushes use a request-shutdown mechanism to ensure Tolgee is only updated after Drupal successfully commits the database revision.

## Installation
1. Install via Composer:
  ```bash
  composer require drupal/tmgmt_tolgee
  ```
2. Enable the modules:
  ```bash
  drush en tmgmt_tolgee tmgmt_tolgee_reverse_sync
  ```
3. Ensure dependencies (Requires tmgmt, key, guzzle and tagify) are enabled.

## Configuration
### 1. Configure API Key
1. Go to **Configuration > System > Keys** (`/admin/config/system/keys`).
2. Add a new Key (Type: Authentication/String).
3. Value: Your Tolgee API Key (Project Settings > API Keys).

### 2. Add Translator
1. Go to **Translation > Providers** (`/admin/tmgmt/translators`).
2. Add Translator.
3. **Label**: "Tolgee".
4. **Provider Plugin**: `Tolgee Translator`.
5. **Settings:**

   * **Base URL**: `https://app.tolgee.io` (or your self-hosted instance URL).
   * **API Key**: Select the Key created in step 1.
   * **Project ID**: Found in your Tolgee Project Settings. Required if using a Personal Access Token (PAT). Optional for Project API Keys.
   * **Auto Sync**: Check this box to enable **Cron Automation** (Auto-Push/Pull).
   * **Auto Accept**: Check this box to automatically accept/publish translations upon import.

### 3. Reverse Sync Submodule
Enable this in the submodule settings to allow local Drupal edits to overwrite Tolgee strings.
* **Workflow**: The Reverse Sync Loop supports a bidirectional "Source of Truth" workflow:
    * Local Edit: An admin edits a translated term (e.g., "Personne") in Drupal.
    * Change Detection: An event subscriber detects the change and moves the TMGMT Job Item to Needs Review.
    * Approval: Once the admin clicks "Save and Finish" (Accept), the change is confirmed locally.
    * Remote Push: A background service (TolgeePusher) sends a lightweight JSON POST to the Tolgee /translations endpoint, updating the remote string using the persistent key.
    * Data Flattening: Uses the TMGMT Data service to accurately map complex nested Drupal entities to flat Tolgee translation keys.
    ## Compatibility & Tiers

### Cloud vs. Self-Hosted
This module is fully compatible with both **Tolgee Cloud** (`app.tolgee.io`) and **Self-Hosted** instances.
* **Cloud**: Use the default Base URL `https://app.tolgee.io`.
* **Self-Hosted**: Enter your custom instance URL (e.g., `https://tolgee.mycompany.com`) in the provider settings.

### Free vs. Business/Enterprise
The module is designed to work with **all Tolgee pricing tiers**, including the Free/Open Source Community edition.
* **No Webhooks Required**: It uses an active **Polling** mechanism (via Cron) rather than passive Webhooks. This ensures compatibility with tiers that do not support webhooks or environments behind firewalls.
* **API Rate Limits**: The **ETag** efficiency feature is specifically implemented to respect API usage limits on Cloud plans by avoiding unnecessary data transfer.

## Advanced Features

### Automatic & Dynamic Namespacing
To keep your translations organized in Tolgee, the module attempts to automatically detect the "context" or **Namespace** of the exported content.

#### Namespace Mapping (Dynamic UI)
You can define your own rules in the Provider Settings > **Namespace Mapping Rules**.
* **Rows**: Each row defines a target Namespace (e.g., `content`, `auth`).
* **Sources**: Use the **Entity Types** field to select one or multiple sources (Sources). This field supports auto-complete/tagged selection (e.g., type "node", "user").
* **Add Another**: Click "Add another mapping" to create a new rule.
* **Remove**: Click the `×` button to remove a rule.

#### Built-in Defaults (Fallback)
If no mapping is found for a specific Item Type, the module falls back to these defaults:

| Content Type | Namespace | Logic |
| :--- | :--- | :--- |
| **Menus** | `navigation` | Detected if the item is a Menu Link or label contains "menu". |
| **Auth** | `auth` | Detected for User entities, Login/Register forms, or "account" labels. |
| **Forms** | `forms` | Webforms, Contact Messages, or Field Config. |
| **Content** | `content` | Nodes, Media, Taxonomy, Custom Blocks. |
| **Actions** | `actions` | Single-word verbs like "Save", "Edit", "Delete". |

### Tagging Strategy
The module creates tags to help you filter and manage keys in the Tolgee Platform:
1.  **Source Tag**: `source-[LANG]` (e.g., `source-en`). Indicates the origin language.
2.  **Custom Tags**: You can add arbitrary comma-separated tags in the Job settings before submission.

## Technical Details

* **Export Format**: Requesting `format=JSON` & `zip=false` from Tolgee API.
* **Key Mapping**: Directly maps the JSON Key Name to the Drupal Source Data, ensuring 100% metadata fidelity.
* **State API**: Stores ETag values in `tmgmt_tolgee.etag.[job_id]` to track versioning.

## Scalability & Limits
The module includes built-in protections for large datasets (e.g. vocabularies with 5000+ terms):
* **Cron Batching**: Processes a maximum of **20 jobs** per cron run to prevent shutdowns.
* **Large Job Pagination**: If a single job contains more than **200 items** (common with Continuous Jobs), the module automatically chunks the synchronization. It will process 200 items per cron run, cycling through the list until complete.
* **Efficient Pulls**: Uses JSON export mode (zip=false) and conditional HTTP requests (ETags/304) to minimize bandwidth.

## Troubleshooting

### Why are my jobs re-opening to "Needs Review"?
This occurs in two scenarios:
1.  **Local Edit**: You changed a translation in Drupal (Reverse Sync triggers Review).
2.  **Remote Update**: Someone updated the translation in Tolgee (Pull triggers Review).
Check the logs (`/admin/reports/dblog`) if unsure.

### Why are remote changes not appearing immediately?
*   **Cron**: Ensure Cron is running (`drush cron`).
*   **Caching**: If Tolgee reports no changes (304 Not Modified), download is skipped.
*   **Pagination**: For very large jobs (>200 items), the module syncs in batches. It may take multiple cron runs to update everything.