<?php

namespace Drupal\tmgmt_tolgee_reverse_sync\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Tolgee Reverse Sync settings.
 */
class ReverseSyncSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'tmgmt_tolgee_reverse_sync_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['tmgmt_tolgee_reverse_sync.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('tmgmt_tolgee_reverse_sync.settings');

    $form['enable_reverse_sync'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Locally Revisionable Content'),
      '#description' => $this->t('If checked, changes made to local Drupal content will revert the associated TMGMT Job status to "Needs Review" instead of being overwritten.'),
      '#default_value' => $config->get('enable_reverse_sync'),
    ];

    $form['allow_push_back'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Allow Review and Push'),
      '#default_value' => $config->get('allow_push_back'),
      '#description' => $this->t('If enabled, accepting a local translation review will queue it to be pushed back to Tolgee.') . 
        '<br><br><div class="messages messages--error"><strong>' . 
        $this->t('DANGER: This logic will OVERWRITE existing keys in Tolgee with local Drupal content. Every time an admin clicks "Accept" on a translation item, that text is slated to replace the version in the Tolgee project.') . 
        '</strong></div>',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('tmgmt_tolgee_reverse_sync.settings')
      ->set('enable_reverse_sync', $form_state->getValue('enable_reverse_sync'))
      ->set('allow_push_back', $form_state->getValue('allow_push_back'))
      ->save();

    parent::submitForm($form, $form_state);
  }
}