<?php

namespace Drupal\Tests\tmgmt_tolgee\Unit\Plugin\tmgmt\Translator;

use Drupal\Tests\UnitTestCase;
use Drupal\tmgmt_tolgee\Plugin\tmgmt\Translator\TolgeeTranslator;
use Drupal\tmgmt\TranslatorInterface;
use Drupal\tmgmt\JobInterface;
use Drupal\tmgmt\JobItemInterface;
use GuzzleHttp\ClientInterface;
use Drupal\key\KeyRepositoryInterface;
use Drupal\Core\File\FileSystemInterface;
use Drupal\Component\Plugin\PluginManagerInterface;
use Drupal\Core\State\StateInterface;

/**
 * @coversDefaultClass \Drupal\tmgmt_tolgee\Plugin\tmgmt\Translator\TolgeeTranslator
 * @group tmgmt_tolgee
 */
class TolgeeTranslatorTest extends UnitTestCase {

  protected $client;
  protected $keyRepository;
  protected $fileSystem;
  protected $formatManager;
  protected $state;
  protected $translatorPlugin;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->client = $this->createMock(ClientInterface::class);
    $this->keyRepository = $this->createMock(KeyRepositoryInterface::class);
    $this->fileSystem = $this->createMock(FileSystemInterface::class);
    $this->formatManager = $this->createMock(PluginManagerInterface::class);
    $this->state = $this->createMock(StateInterface::class);

    $configuration = [];
    $plugin_id = 'tolgee';
    $plugin_definition = [];

    $this->translatorPlugin = new TolgeeTranslator(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $this->client,
      $this->keyRepository,
      $this->fileSystem,
      $this->formatManager,
      $this->state
    );
  }

  /**
   * Tests getProjectUrl method.
   */
  public function testGetProjectUrl() {
    $translator = $this->createMock(TranslatorInterface::class);
    $translator->method('getSetting')
      ->willReturnMap([
        ['base_url', 'https://app.tolgee.io'],
        ['project_id', '123'],
      ]);

    $url = $this->translatorPlugin->getProjectUrl($translator);
    $this->assertEquals('https://app.tolgee.io/v2/projects/123', $url);

    // Test without project ID
    $translatorNoId = $this->createMock(TranslatorInterface::class);
    $translatorNoId->method('getSetting')
      ->willReturnMap([
        ['base_url', 'https://self-hosted.com/'],
        ['project_id', ''],
      ]);
    $url = $this->translatorPlugin->getProjectUrl($translatorNoId);
    $this->assertEquals('https://self-hosted.com/v2/projects', $url);
  }

  /**
   * Tests determineNamespace logic.
   */
  public function testDetermineNamespace() {
    $job = $this->createMock(JobInterface::class);
    $item = $this->createMock(JobItemInterface::class);
    $item->method('getItemType')->willReturn('node');
    
    $job->method('getItems')->willReturn([$item]);
    
    $translator = $this->createMock(TranslatorInterface::class);
    $job->method('getTranslator')->willReturn($translator);
    
    $mapping = [
      ['namespace' => 'content', 'types' => ['node', 'media']],
      ['namespace' => 'config', 'types' => ['block']],
    ];
    
    $translator->method('getSetting')
      ->with('namespace_mapping')
      ->willReturn($mapping);

    $ns = $this->translatorPlugin->determineNamespace($job);
    $this->assertEquals('content', $ns);
    
    // Test No Match
    $item2 = $this->createMock(JobItemInterface::class);
    $item2->method('getItemType')->willReturn('taxonomy_term');
    $job2 = $this->createMock(JobInterface::class);
    $job2->method('getItems')->willReturn([$item2]);
    $job2->method('getTranslator')->willReturn($translator);

    $ns2 = $this->translatorPlugin->determineNamespace($job2);
    $this->assertNull($ns2);
  }
}
