/**
 * @file
 * Tolgee Tagify integration.
 */

((Drupal, once, drupalSettings) => {

  Drupal.behaviors.tolgeeTagify = {
    attach: (context) => {
      // STRICT SELECTOR: Targets only the input, not the wrapper.
      const selector = 'input.js-tolgee-source-types';
      const whitelist = drupalSettings.tolgee?.whitelist || [];

      once('tolgee-tagify', selector, context).forEach((input) => {
        if (!window.Tagify) {
          return;
        }

        const tagify = new window.Tagify(input, {
          whitelist: whitelist,
          enforceWhitelist: true,
          dropdown: {
            maxItems: 20,
            classname: 'tags-look',
            enabled: 0,
            closeOnSelect: false,
          },
        });
      });
    },
  };

})(Drupal, once, drupalSettings);