<?php

namespace Drupal\Tests\tmgmt_tolgee_reverse_sync\Unit;

use Drupal\Tests\UnitTestCase;
use Drupal\tmgmt_tolgee_reverse_sync\TolgeePusher;
use Drupal\tmgmt\Data;
use Drupal\tmgmt\JobItemInterface;
use Drupal\tmgmt\JobInterface;
use Drupal\tmgmt\TranslatorInterface;
use Drupal\tmgmt_tolgee\Plugin\tmgmt\Translator\TolgeeTranslator;
use Drupal\key\KeyRepositoryInterface;
use Drupal\key\KeyInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Logger\LoggerChannelInterface;
use GuzzleHttp\ClientInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * @coversDefaultClass \Drupal\tmgmt_tolgee_reverse_sync\TolgeePusher
 * @group tmgmt_tolgee
 */
class TolgeePusherTest extends UnitTestCase {

  protected $client;
  protected $keyRepository;
  protected $loggerFactory;
  protected $tmgmtData;
  protected $pusher;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->client = $this->createMock(ClientInterface::class);
    $this->keyRepository = $this->createMock(KeyRepositoryInterface::class);
    $this->loggerFactory = $this->createMock(LoggerChannelFactoryInterface::class);
    $this->tmgmtData = $this->createMock(Data::class);
    
    // Mock logger
    $logger = $this->createMock(LoggerChannelInterface::class);
    $this->loggerFactory->method('get')->willReturn($logger);

    $this->pusher = new TolgeePusher(
      $this->client,
      $this->keyRepository,
      $this->loggerFactory,
      $this->tmgmtData
    );
  }

  /**
   * Tests pushItem method with successful response.
   */
  public function testPushItem() {
    // 1. Mock Job Item hierarchy
    $item = $this->createMock(JobItemInterface::class);
    $job = $this->createMock(JobInterface::class);
    $translator = $this->createMock(TranslatorInterface::class);
    $plugin = $this->createMock(TolgeeTranslator::class);

    $item->method('getJob')->willReturn($job);
    $item->method('getItemType')->willReturn('node');
    $item->method('getItemId')->willReturn('123');
    $item->method('getData')->willReturn([]);
    
    $job->method('getTranslator')->willReturn($translator);
    $job->method('getTargetLanguage')->willReturn($this->createMock(LanguageInterface::class));
    $job->target_language = $this->createMock(LanguageInterface::class);
    $job->target_language->method('getId')->willReturn('fr');

    $translator->method('getPlugin')->willReturn($plugin);
    $translator->method('getSetting')->with('api_key')->willReturn('test_key_id');

    // 2. Mock Plugin methods
    $plugin->method('getProjectUrl')->willReturn('https://api.tolgee.io/v2/projects/1');
    $plugin->method('determineNamespace')->willReturn('content');

    // 3. Mock Key Repository
    $keyEntity = $this->createMock(KeyInterface::class);
    $keyEntity->method('getKeyValue')->willReturn('tgpat_secret');
    $this->keyRepository->method('getKey')->with('test_key_id')->willReturn($keyEntity);

    // 4. Mock Data Flattening
    $this->tmgmtData->method('flatten')->willReturn([
      'field_body][0][value' => [
        '#translation' => ['#text' => 'Bonjour le monde'],
      ]
    ]);

    // 5. EXPECTATION: Guzzle Request
    $this->client->expects($this->once())
      ->method('request')
      ->with(
        'POST',
        'https://api.tolgee.io/v2/projects/1/translations',
        $this->callback(function($options) {
          return 
            $options['headers']['X-API-Key'] === 'tgpat_secret' &&
            $options['json']['key'] === 'node:123][field_body][0][value' &&
            $options['json']['namespace'] === 'content' &&
            $options['json']['translations']['fr'] === 'Bonjour le monde';
        })
      );

    $this->pusher->pushItem($item);
  }
}
