<?php

namespace Drupal\tmgmt_tolgee\Plugin\tmgmt\Translator;

use Drupal\tmgmt\JobInterface;
use Drupal\tmgmt\JobItemInterface;
use Drupal\tmgmt_extension_suit\ExtendedTranslatorPluginInterface;
use Drupal\file\FileInterface;

/**
 * Extended Tolgee translator.
 *
 * This class is a "Decorator" that adds the Extension Suit interface
 * to the standard Tolgee translator. It is loaded dynamically via
 * hook_tmgmt_translator_info_alter().
 */
class TolgeeExtendedTranslator extends TolgeeTranslator implements ExtendedTranslatorPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function checkFile(JobInterface $job) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function isReadyForDownload(JobInterface $job) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function downloadTranslation(JobInterface $job, ?JobItemInterface $jobItem = NULL) {
    // Redirect the "Download" action to your standard "Fetch" logic.
    return $this->fetchTranslation($job);
  }

  /**
   * {@inheritdoc}
   */
  public function getFileName(JobInterface $job) {
    return 'job_' . $job->id() . '.xlf';
  }

  /**
   * {@inheritdoc}
   */
  public function getAttachmentFileName(JobInterface $job, FileInterface $file) {
    // Return a dummy filename for attachments.
    return 'job_' . $job->id() . '_file_' . $file->id() . '.xlf';
  }

  /**
   * {@inheritdoc}
   */
  public function isAttachmentReadyForDownload(JobInterface $job, FileInterface $file) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function downloadAttachmentTranslation(JobInterface $job, FileInterface $file) {
    // No-op: Tolgee translates content strings via API, not file attachments.
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function cancelTranslation(JobInterface $job) {
    $job->aborted();
    $job->addMessage('Job has been aborted.');
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function requestTranslationExtended(JobInterface $job, array $items) {
    // The Extension Suit allows requesting translation for specific items.
    // Since Tolgee uses a full Job Export/Import flow, we simply trigger
    // the standard requestTranslation which processes the whole job.
    // Tolgee handles key deduplication, so re-sending items is safe.
    return $this->requestTranslation($job);
  }

}
